/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.JsonToRow;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Rule;
import org.junit.Test;

public class JsonToRowSqlTest {
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testParsesRows() throws Exception {
        Schema personSchema = Schema.builder().addStringField("name").addInt32Field("height").addBooleanField("knowsJavascript").build();
        PCollection jsonPersons = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)this.jsonPerson("person1", "80", "true"), (Object[])new String[]{this.jsonPerson("person2", "70", "false"), this.jsonPerson("person3", "60", "true"), this.jsonPerson("person4", "50", "false"), this.jsonPerson("person5", "40", "true")}));
        Schema resultSchema = Schema.builder().addInt32Field("avg_height").build();
        PCollection sqlResult = (PCollection)((PCollection)jsonPersons.apply(JsonToRow.withSchema((Schema)personSchema))).apply((PTransform)SqlTransform.query((String)"SELECT AVG(height) as avg_height FROM PCOLLECTION"));
        PAssert.that((PCollection)sqlResult).containsInAnyOrder((Object[])new Row[]{this.row(resultSchema, 60)});
        this.pipeline.run();
    }

    private String jsonPerson(String name, String height, String knowsJs) {
        return "{\n  \"name\": \"" + name + "\",\n  \"height\": " + height + ",\n  \"knowsJavascript\": " + knowsJs + "\n}";
    }

    private Row row(Schema schema, Object ... values) {
        return Row.withSchema((Schema)schema).addValues(values).build();
    }
}

