/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CalciteParsesSimpleIdentifiersTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private final String input;
    private final String expected;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"field_id", "field_id"}, {"`field_id`", "field_id"}, {"`field``id`", "field`id"}, {"`field id`", "field id"}, {"`field-id`", "field-id"}, {"`field=id`", "field=id"}, {"`field.id`", "field.id"}, {"`field{id}`", "field{id}"}, {"`field|id`", "field|id"}, {"`field\\id`", "field\\id"}, {"`field\\a_id`", "field\\a_id"}, {"`field\b_id`", "field\b_id"}, {"`field\\b_id`", "field\\b_id"}, {"`field\\f_id`", "field\\f_id"}, {"`field\\n_id`", "field\\n_id"}, {"`field\\r_id`", "field\\r_id"}, {"`field\tid`", "field\tid"}, {"`field\\t_id`", "field\\t_id"}, {"`field\\v_id`", "field\\v_id"}, {"`field\\\\_id`", "field\\\\_id"}, {"`field\\?_id`", "field\\?_id"});
    }

    public CalciteParsesSimpleIdentifiersTest(String input, String expected) {
        this.input = input;
        this.expected = expected;
    }

    @Test
    public void testParsesAlias() {
        MatcherAssert.assertThat(this.alias(this.input), this.parsedAs(this.expected));
    }

    private PCollection<Row> alias(String alias) {
        return (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)String.format("SELECT 321 AS %s", alias)));
    }

    private Matcher<PCollection<Row>> parsedAs(final String expected) {
        return new BaseMatcher<PCollection<Row>>(){

            public boolean matches(Object actual) {
                PCollection result = (PCollection)actual;
                PAssert.thatSingleton((PCollection)result).satisfies(CalciteParsesSimpleIdentifiersTest.this.assertFieldNameIs(expected));
                CalciteParsesSimpleIdentifiersTest.this.pipeline.run();
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("field alias matches");
            }
        };
    }

    private SerializableFunction<Row, Void> assertFieldNameIs(String expected) {
        return (SerializableFunction & Serializable)row -> {
            Assert.assertEquals((Object)expected, (Object)this.onlyField((Row)row).getName());
            return null;
        };
    }

    private Schema.Field onlyField(Row row) {
        Assert.assertEquals((long)1L, (long)row.getFieldCount());
        return row.getSchema().getField(0);
    }
}

