/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.testing.TestPipeline;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CalciteCannotParseSimpleIdentifiersTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private final String input;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object> data() {
        return Arrays.asList("field id", "field\nid", "`field\nid`", "field`id", "field\\id", "field``id", "field\bid", "field=id", "field+id", "field{id}", "field.id", "field\r_id", "`field\r_id`");
    }

    public CalciteCannotParseSimpleIdentifiersTest(String input) {
        this.input = input;
    }

    @Test
    public void testFailsToParseAlias() {
        Assert.assertThrows(ParseException.class, (ThrowingRunnable)this.attemptParse(this.input));
    }

    private ThrowingRunnable attemptParse(String alias) {
        return () -> BeamSqlEnv.inMemory((TableProvider[])new TableProvider[0]).isDdl(String.format("SELECT 321 AS %s", alias));
    }
}

