/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Arrays;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamPCollectionTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlMultipleSchemasTest {
    private static final Schema ROW_SCHEMA = Schema.builder().addInt32Field("f_int").addStringField("f_string").build();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testSelectFromQualifiedPCollection() {
        PCollection input = (PCollection)this.pipeline.apply(this.create(this.row(1, "strstr")));
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM beam.PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "strstr")});
        this.pipeline.run();
    }

    @Test
    public void testSelectFromUnqualifiedPCollection() {
        PCollection input = (PCollection)this.pipeline.apply(this.create(this.row(1, "strstr")));
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "strstr")});
        this.pipeline.run();
    }

    @Test
    public void testSelectFromExtraSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM extraSchema.extraTable").withTableProvider("extraSchema", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testOverrideUnqualifiedMainSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM extraTable").withTableProvider("beam", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testOverrideQualifiedMainSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM beam.extraTable").withTableProvider("beam", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testSetDefaultUnqualifiedSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM extraTable").withDefaultTableProvider("extraSchema", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testSetDefaultUnqualifiedSchemaAndJoin() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT extra.f_int, main.f_string || extra.f_string AS f_string \nFROM extraTable AS extra \n   INNER JOIN \n beam.PCOLLECTION AS main \n   ON main.f_int = extra.f_int").withDefaultTableProvider("extraSchema", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "pcollection_1_extra_table_1"), this.row(2, "pcollection_2_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testSetDefaultQualifiedSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT f_int, f_string FROM extraSchema.extraTable").withDefaultTableProvider("extraSchema", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testJoinWithExtraSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT extra.f_int, main.f_string || extra.f_string AS f_string \nFROM extraSchema.extraTable AS extra \n   INNER JOIN \n PCOLLECTION AS main \n   ON main.f_int = extra.f_int").withTableProvider("extraSchema", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "pcollection_1_extra_table_1"), this.row(2, "pcollection_2_extra_table_2")});
        this.pipeline.run();
    }

    @Test
    public void testJoinQualifiedMainWithExtraSchema() {
        PCollection inputMain = (PCollection)this.pipeline.apply("mainInput", this.create(this.row(1, "pcollection_1"), this.row(2, "pcollection_2")));
        PCollection inputExtra = (PCollection)this.pipeline.apply("extraInput", this.create(this.row(1, "_extra_table_1"), this.row(2, "_extra_table_2")));
        TableProvider extraInputProvider = this.extraTableProvider("extraTable", (PCollection<Row>)inputExtra);
        PCollection result = (PCollection)inputMain.apply((PTransform)SqlTransform.query((String)"SELECT extra.f_int, main.f_string || extra.f_string AS f_string \nFROM extraSchema.extraTable AS extra \n   INNER JOIN \n beam.PCOLLECTION AS main \n   ON main.f_int = extra.f_int").withTableProvider("extraSchema", extraInputProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "pcollection_1_extra_table_1"), this.row(2, "pcollection_2_extra_table_2")});
        this.pipeline.run();
    }

    private TableProvider extraTableProvider(String tableName, PCollection<Row> rows) {
        return new ReadOnlyTableProvider("testExtraTableProvider", (Map)ImmutableMap.of((Object)tableName, (Object)new BeamPCollectionTable(rows)));
    }

    private Row row(int fIntValue, String fStringValue) {
        return Row.withSchema((Schema)ROW_SCHEMA).addValues(new Object[]{fIntValue, fStringValue}).build();
    }

    private PTransform<PBegin, PCollection<Row>> create(Row ... rows) {
        return Create.of(Arrays.asList(rows)).withRowSchema(ROW_SCHEMA);
    }
}

