/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.extensions.sql.BeamSqlCli;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;

public class BeamSqlExplainTest {
    private InMemoryMetaStore metaStore;
    private BeamSqlCli cli;

    @Before
    public void setUp() throws SqlParseException, RelConversionException, ValidationException {
        this.metaStore = new InMemoryMetaStore();
        this.metaStore.registerProvider((TableProvider)new TextTableProvider());
        this.cli = new BeamSqlCli().metaStore((MetaStore)this.metaStore);
        this.cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' ");
        this.cli.execute("CREATE EXTERNAL TABLE A (\nc1 int COMMENT 'c1',\nc2 int COMMENT 'c2')\nTYPE 'text'\nCOMMENT '' ");
        this.cli.execute("CREATE EXTERNAL TABLE B (\nc1 int COMMENT 'c1',\nc2 int COMMENT 'c2')\nTYPE 'text'\nCOMMENT '' ");
    }

    @Ignore
    public void testExplainCommaJoin() {
        String plan = this.cli.explainQuery("SELECT A.c1, B.c2 FROM A, B WHERE A.c1 = B.c2 AND A.c1 > 0");
        Assert.assertEquals((Object)"BeamCalcRel(expr#0..3=[{inputs}], c1=[$t0], c2=[$t3])\n  BeamCoGBKJoinRel(condition=[=($0, $3)], joinType=[inner])\n    BeamCalcRel(expr#0..1=[{inputs}], expr#2=[0], expr#3=[>($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n      BeamIOSourceRel(table=[[beam, A]])\n    BeamIOSourceRel(table=[[beam, B]])\n", (Object)plan);
    }
}

