/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Arrays;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.junit.Rule;
import org.junit.Test;

public class BeamSqlDslUnnestRowsTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testUnnestArrayWithNestedRows() {
        Schema level3Type = Schema.builder().addInt32Field("c1").addStringField("c2").addDoubleField("c3").build();
        Row level3Row1 = Row.withSchema((Schema)level3Type).addValues(new Object[]{1, "row", 1.0}).build();
        Row level3Row2 = Row.withSchema((Schema)level3Type).addValues(new Object[]{2, "row", 2.0}).build();
        Row level3Row3 = Row.withSchema((Schema)level3Type).addValues(new Object[]{3, "row", 3.0}).build();
        Schema level2Type = Schema.builder().addInt32Field("b1").addStringField("b2").addRowField("b3", level3Type).addDoubleField("b4").build();
        Row level2Row1 = Row.withSchema((Schema)level2Type).addValues(new Object[]{1, "row", level3Row1, 1.0}).build();
        Row level2Row2 = Row.withSchema((Schema)level2Type).addValues(new Object[]{2, "row", level3Row2, 2.0}).build();
        Row level2Row3 = Row.withSchema((Schema)level2Type).addValues(new Object[]{3, "row", level3Row3, 3.0}).build();
        Schema level1Type = Schema.builder().addInt32Field("a1").addStringField("a2").addDoubleField("a3").addArrayField("a4", Schema.FieldType.row((Schema)level2Type)).build();
        Row level1Row1 = Row.withSchema((Schema)level1Type).addValues(new Object[]{1, "row", 1.0, Arrays.asList(level2Row1, level2Row2, level2Row3)}).build();
        Row level1Row2 = Row.withSchema((Schema)level1Type).addValues(new Object[]{2, "row", 2.0, Arrays.asList(level2Row1, level2Row2, level2Row3)}).build();
        Row level1Row3 = Row.withSchema((Schema)level1Type).addValues(new Object[]{3, "row", 3.0, Arrays.asList(level2Row1, level2Row2, level2Row3)}).build();
        PCollection inputTable = (PCollection)PBegin.in((Pipeline)this.pipeline).apply((PTransform)Create.of((Object)level1Row1, (Object[])new Row[]{level1Row2, level1Row3}).withRowSchema(level1Type));
        String sql = "select t.a1, t.a2, t.a3, d.b1, d.b2, d.b4, d.b3.c1, d.b3.c2, d.b3.c3 from test t cross join unnest(t.a4) d";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("test"), (PCollection)inputTable).apply((PTransform)SqlTransform.query((String)sql));
        Schema resultSchema = Schema.builder().addInt32Field("a1").addStringField("a2").addDoubleField("a3").addInt32Field("b1").addStringField("b2").addDoubleField("b4").addInt32Field("c1").addStringField("c2").addDoubleField("c3").build();
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addValues(new Object[]{1, "row", 1.0, 1, "row", 1.0, 1, "row", 1.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{1, "row", 1.0, 2, "row", 2.0, 2, "row", 2.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{1, "row", 1.0, 3, "row", 3.0, 3, "row", 3.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{3, "row", 3.0, 1, "row", 1.0, 1, "row", 1.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{3, "row", 3.0, 2, "row", 2.0, 2, "row", 2.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{3, "row", 3.0, 3, "row", 3.0, 3, "row", 3.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{2, "row", 2.0, 1, "row", 1.0, 1, "row", 1.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{2, "row", 2.0, 2, "row", 2.0, 2, "row", 2.0}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{2, "row", 2.0, 3, "row", 3.0, 3, "row", 3.0}).build()});
        this.pipeline.run();
    }
}

