/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class BeamSqlDslProjectTest
extends BeamSqlDslBase {
    @Test
    public void testSelectAllWithBounded() throws Exception {
        this.runSelectAll((PCollection<Row>)this.boundedInput2);
    }

    @Test
    public void testSelectAllWithUnbounded() throws Exception {
        this.runSelectAll((PCollection<Row>)this.unboundedInput2);
    }

    private void runSelectAll(PCollection<Row> input) throws Exception {
        String sql = "SELECT * FROM PCOLLECTION";
        PCollection result = (PCollection)input.apply("testSelectAll", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{(Row)rowsInTableA.get(0)});
        this.pipeline.run();
    }

    @Test
    public void testPartialFieldsWithBounded() throws Exception {
        this.runPartialFields((PCollection<Row>)this.boundedInput2);
    }

    @Test
    public void testPartialFieldsWithUnbounded() throws Exception {
        this.runPartialFields((PCollection<Row>)this.unboundedInput2);
    }

    private void runPartialFields(PCollection<Row> input) throws Exception {
        String sql = "SELECT f_int, f_long FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testPartialFields", (PTransform)SqlTransform.query((String)sql));
        Schema resultType = Schema.builder().addInt32Field("f_int").addInt64Field("f_long").build();
        Row row = this.rowAtIndex(resultType, 0);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{row});
        this.pipeline.run();
    }

    @Test
    public void testPartialFieldsInMultipleRowWithBounded() throws Exception {
        this.runPartialFieldsInMultipleRow((PCollection<Row>)this.boundedInput1);
    }

    @Test
    public void testPartialFieldsInMultipleRowWithUnbounded() throws Exception {
        this.runPartialFieldsInMultipleRow((PCollection<Row>)this.unboundedInput1);
    }

    private void runPartialFieldsInMultipleRow(PCollection<Row> input) throws Exception {
        String sql = "SELECT f_int, f_long FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testPartialFieldsInMultipleRow", (PTransform)SqlTransform.query((String)sql));
        Schema resultType = Schema.builder().addInt32Field("f_int").addInt64Field("f_long").build();
        List expectedRows = IntStream.range(0, 4).mapToObj(i -> this.rowAtIndex(resultType, i)).collect(Collectors.toList());
        PAssert.that((PCollection)result).containsInAnyOrder(expectedRows);
        this.pipeline.run();
    }

    private Row rowAtIndex(Schema schema, int index) {
        return Row.withSchema((Schema)schema).addValues(new Object[]{((Row)rowsInTableA.get(index)).getValue(0), ((Row)rowsInTableA.get(index)).getValue(1)}).build();
    }

    @Test
    public void testPartialFieldsInRowsWithBounded() throws Exception {
        this.runPartialFieldsInRows((PCollection<Row>)this.boundedInput1);
    }

    @Test
    public void testPartialFieldsInRowsWithUnbounded() throws Exception {
        this.runPartialFieldsInRows((PCollection<Row>)this.unboundedInput1);
    }

    private void runPartialFieldsInRows(PCollection<Row> input) throws Exception {
        String sql = "SELECT f_int, f_long FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testPartialFieldsInRows", (PTransform)SqlTransform.query((String)sql));
        Schema resultType = Schema.builder().addInt32Field("f_int").addInt64Field("f_long").build();
        List expectedRows = IntStream.range(0, 4).mapToObj(i -> this.rowAtIndex(resultType, i)).collect(Collectors.toList());
        PAssert.that((PCollection)result).containsInAnyOrder(expectedRows);
        this.pipeline.run();
    }

    @Test
    public void testLiteralFieldWithBounded() throws Exception {
        this.runLiteralField((PCollection<Row>)this.boundedInput2);
    }

    @Test
    public void testLiteralFieldWithUnbounded() throws Exception {
        this.runLiteralField((PCollection<Row>)this.unboundedInput2);
    }

    public void runLiteralField(PCollection<Row> input) throws Exception {
        String sql = "SELECT 1 as literal_field FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testLiteralField", (PTransform)SqlTransform.query((String)sql));
        Schema resultType = Schema.builder().addInt32Field("literal_field").build();
        Row row = Row.withSchema((Schema)resultType).addValues(new Object[]{1}).build();
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{row});
        this.pipeline.run();
    }

    @Test
    public void testProjectUnknownField() throws Exception {
        this.exceptions.expect(ParseException.class);
        this.exceptions.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Column 'f_int_na' not found in any table")));
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT f_int_na FROM TABLE_A";
        PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), (PCollection)this.boundedInput1).apply("testProjectUnknownField", (PTransform)SqlTransform.query((String)sql));
        this.pipeline.run();
    }

    @Test
    public void testTrivialProjection() {
        String sql = "SELECT c_int64 as abc FROM PCOLLECTION";
        Schema inputSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"c_int64", (Schema.FieldType)Schema.FieldType.INT64)});
        Schema outputSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"abc", (Schema.FieldType)Schema.FieldType.INT64)});
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputSchema).addValue((Object)42L).build(), (Object[])new Row[0]).withRowSchema(inputSchema));
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)sql));
        Assert.assertEquals((Object)outputSchema, (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)outputSchema).addValue((Object)42L).build()});
        this.pipeline.run();
    }

    @Test
    public void testBytesLiteral() {
        Schema outputSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"c_bytes", (Schema.FieldType)Schema.FieldType.BYTES)});
        PCollection result = (PCollection)PCollectionTuple.empty((Pipeline)this.pipeline).apply((PTransform)SqlTransform.query((String)"SELECT x'baadcafe' as c_bytes"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)outputSchema).addValue((Object)new byte[]{-70, -83, -54, -2}).build()});
        this.pipeline.run();
    }
}

