/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlDslNestedRowsTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testRowConstructorKeyword() {
        Schema nestedSchema = Schema.builder().addInt32Field("f_nestedInt").addStringField("f_nestedString").addInt32Field("f_nestedIntPlusOne").build();
        Schema schema = Schema.builder().addInt32Field("f_int").addRowField("f_row", nestedSchema).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)schema).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{312, "CC", 313}).build()}).build(), (Object[])new Row[0]).withRowSchema(schema));
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT 1 as `f_int`, ROW(3, 'BB', f_int + 1) as `f_row1` FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{3, "BB", 2}).build()}).build()});
        this.pipeline.run();
    }

    @Test
    public void testRowAliasAsRow() {
        Schema nestedSchema = Schema.builder().addStringField("f_nestedString").addInt32Field("f_nestedInt").addInt32Field("f_nestedIntPlusOne").build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addRowField("f_row", nestedSchema).build();
        Schema outputType = Schema.builder().addInt32Field("f_int").addRowField("f_row1", nestedSchema).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).attachValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).attachValues(new Object[]{"CC", 312, 313})}), (Object[])new Row[0]).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT 1 as `f_int`, f_row as `f_row1` FROM PCOLLECTION"))).setRowSchema(outputType);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)outputType).attachValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).attachValues(new Object[]{"CC", 312, 313})})});
        this.pipeline.run();
    }

    @Test
    public void testRowConstructorKeywordKeepAsRow() {
        Schema nestedSchema = Schema.builder().addStringField("f_nestedString").addInt32Field("f_nestedInt").addInt32Field("f_nestedIntPlusOne").build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addRowField("f_row", nestedSchema).build();
        Schema nestedOutput = Schema.builder().addInt32Field("int_field").addStringField("str_field").build();
        Schema outputType = Schema.builder().addInt32Field("f_int1").addRowField("f_row1", nestedOutput).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).attachValues(new Object[]{2, Row.withSchema((Schema)nestedSchema).attachValues(new Object[]{"CC", 312, 313})}), (Object[])new Row[0]).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_int as `f_int1`, (`PCOLLECTION`.`f_row`.`f_nestedInt`, `PCOLLECTION`.`f_row`.`f_nestedString`) as `f_row1` FROM PCOLLECTION"))).setRowSchema(outputType);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)outputType).attachValues(new Object[]{2, Row.withSchema((Schema)nestedOutput).attachValues(new Object[]{312, "CC"})})});
        this.pipeline.run();
    }

    @Test
    public void testRowConstructorBraces() {
        Schema nestedSchema = Schema.builder().addInt32Field("f_nestedInt").addStringField("f_nestedString").addInt32Field("f_nestedIntPlusOne").build();
        Schema schema = Schema.builder().addInt32Field("f_int").addRowField("f_row", nestedSchema).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)schema).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{312, "CC", 313}).build()}).build(), (Object[])new Row[0]).withRowSchema(schema));
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT 1 as `f_int`, (3, 'BB', f_int + 1) as `f_row1` FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{3, "BB", 2}).build()}).build()});
        this.pipeline.run();
    }

    @Test
    public void testNestedRowFieldAccess() {
        Schema nestedSchema = Schema.builder().addInt32Field("f_nestedInt").addStringField("f_nestedString").addInt32Field("f_nestedIntPlusOne").build();
        Schema resultSchema = Schema.builder().addStringField("f_nestedString").build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addRowField("f_nestedRow", nestedSchema).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{312, "CC", 313}).build()}).build(), (Object[])new Row[]{Row.withSchema((Schema)inputType).addValues(new Object[]{2, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{412, "DD", 413}).build()}).build()}).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT `PCOLLECTION`.`f_nestedRow`.`f_nestedString` FROM PCOLLECTION"))).setRowSchema(resultSchema);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addValues(new Object[]{"CC"}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{"DD"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testNestedRowArrayFieldAccess() {
        Schema resultSchema = Schema.builder().addArrayField("f_nestedArray", Schema.FieldType.STRING).build();
        Schema nestedSchema = Schema.builder().addInt32Field("f_nestedInt").addStringField("f_nestedString").addInt32Field("f_nestedIntPlusOne").addArrayField("f_nestedArray", Schema.FieldType.STRING).build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addRowField("f_nestedRow", nestedSchema).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{312, "CC", 313, Arrays.asList("one", "two")}).build()}).build(), (Object[])new Row[]{Row.withSchema((Schema)inputType).addValues(new Object[]{2, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{412, "DD", 413, Arrays.asList("three", "four")}).build()}).build()}).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT `PCOLLECTION`.`f_nestedRow`.`f_nestedArray` FROM PCOLLECTION"))).setRowSchema(resultSchema);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addArray(Arrays.asList("one", "two")).build(), Row.withSchema((Schema)resultSchema).addArray(Arrays.asList("three", "four")).build()});
        this.pipeline.run();
    }

    @Test
    public void testNestedRowArrayElementAccess() {
        Schema resultSchema = Schema.builder().addStringField("f_nestedArrayStringField").build();
        Schema nestedSchema = Schema.builder().addInt32Field("f_nestedInt").addStringField("f_nestedString").addInt32Field("f_nestedIntPlusOne").addArrayField("f_nestedArray", Schema.FieldType.STRING).build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addRowField("f_nestedRow", nestedSchema).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).addValues(new Object[]{1, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{312, "CC", 313, Arrays.asList("one", "two")}).build()}).build(), (Object[])new Row[]{Row.withSchema((Schema)inputType).addValues(new Object[]{2, Row.withSchema((Schema)nestedSchema).addValues(new Object[]{412, "DD", 413, Arrays.asList("three", "four")}).build()}).build()}).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT `PCOLLECTION`.`f_nestedRow`.`f_nestedArray`[2] FROM PCOLLECTION"))).setRowSchema(resultSchema);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addValues(new Object[]{"two"}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{"four"}).build()});
        this.pipeline.run();
    }
}

