/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class BeamSqlDslFilterTest
extends BeamSqlDslBase {
    @Test
    public void testSingleFilterWithBounded() throws Exception {
        this.runSingleFilter((PCollection<Row>)this.boundedInput1);
    }

    @Test
    public void testSingleFilterWithUnbounded() throws Exception {
        this.runSingleFilter((PCollection<Row>)this.unboundedInput1);
    }

    private void runSingleFilter(PCollection<Row> input) throws Exception {
        String sql = "SELECT * FROM PCOLLECTION WHERE f_int = 1";
        PCollection result = (PCollection)input.apply("testSingleFilter", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{(Row)rowsInTableA.get(0)});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testCompositeFilterWithBounded() throws Exception {
        this.runCompositeFilter((PCollection<Row>)this.boundedInput1);
    }

    @Test
    public void testCompositeFilterWithUnbounded() throws Exception {
        this.runCompositeFilter((PCollection<Row>)this.unboundedInput1);
    }

    private void runCompositeFilter(PCollection<Row> input) throws Exception {
        String sql = "SELECT * FROM TABLE_A WHERE f_int > 1 AND (f_long < 3000 OR f_string = 'string_row3')";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testCompositeFilter", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{(Row)rowsInTableA.get(1), (Row)rowsInTableA.get(2)});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testNoReturnFilterWithBounded() throws Exception {
        this.runNoReturnFilter((PCollection<Row>)this.boundedInput1);
    }

    @Test
    public void testNoReturnFilterWithUnbounded() throws Exception {
        this.runNoReturnFilter((PCollection<Row>)this.unboundedInput1);
    }

    private void runNoReturnFilter(PCollection<Row> input) throws Exception {
        String sql = "SELECT * FROM TABLE_A WHERE f_int < 1";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testNoReturnFilter", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).empty();
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFromInvalidTableName1() throws Exception {
        this.exceptions.expect(ParseException.class);
        this.exceptions.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Object 'TABLE_B' not found")));
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT * FROM TABLE_B WHERE f_int < 1";
        PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), (PCollection)this.boundedInput1).apply("testFromInvalidTableName1", (PTransform)SqlTransform.query((String)sql));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testInvalidFilter() throws Exception {
        this.exceptions.expect(ParseException.class);
        this.exceptions.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Column 'f_int_na' not found in any table")));
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT * FROM PCOLLECTION WHERE f_int_na = 0";
        this.boundedInput1.apply((PTransform)SqlTransform.query((String)sql));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFilterBytes() {
        String sql = "SELECT c_bytes FROM PCOLLECTION WHERE c_bytes = x'ff'";
        Schema schema = Schema.builder().addByteArrayField("c_bytes").build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)schema).addValue((Object)new byte[]{-1}).build(), (Object[])new Row[]{Row.withSchema((Schema)schema).addValue((Object)new byte[]{127}).build()}).withRowSchema(schema));
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValue((Object)new byte[]{-1}).build()});
        this.pipeline.run().waitUntilFinish();
    }
}

