/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.utils.DateTimeUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public class BeamSqlDslBase {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();
    static Schema schemaInTableA;
    static Schema schemaFloatDouble;
    static Schema schemaBytes;
    static Schema schemaBytesPaddingTest;
    static List<Row> rowsInTableA;
    static List<Row> monthlyRowsInTableA;
    static List<Row> rowsOfFloatDouble;
    static List<Row> rowsOfBytes;
    static List<Row> rowsOfBytesPaddingTest;
    protected PCollection<Row> boundedInput1;
    protected PCollection<Row> boundedInput2;
    protected PCollection<Row> boundedInputFloatDouble;
    protected PCollection<Row> boundedInputBytes;
    protected PCollection<Row> boundedInputBytesPaddingTest;
    protected PCollection<Row> boundedInputMonthly;
    protected PCollection<Row> unboundedInput1;
    protected PCollection<Row> unboundedInput2;

    @BeforeClass
    public static void prepareClass() throws ParseException {
        schemaInTableA = Schema.builder().addInt32Field("f_int").addInt64Field("f_long").addInt16Field("f_short").addByteField("f_byte").addFloatField("f_float").addDoubleField("f_double").addStringField("f_string").addField("f_date", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE)).addField("f_time", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).addField("f_datetime", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).addDateTimeField("f_timestamp").addInt32Field("f_int2").addDecimalField("f_decimal").build();
        rowsInTableA = TestUtils.RowsBuilder.of(schemaInTableA).addRows(1, 1000L, (short)1, (byte)1, Float.valueOf(1.0f), 1.0, "string_row1", LocalDate.of(2017, 1, 1), LocalTime.of(1, 1, 3), LocalDateTime.of(2017, 1, 1, 1, 1, 3), DateTimeUtils.parseTimestampWithoutTimeZone("2017-01-01 01:01:03"), 0, new BigDecimal(1)).addRows(2, 2000L, (short)2, (byte)2, Float.valueOf(2.0f), 2.0, "string_row2", LocalDate.of(2017, 1, 1), LocalTime.of(1, 2, 3), LocalDateTime.of(2017, 1, 1, 1, 2, 3), DateTimeUtils.parseTimestampWithoutTimeZone("2017-01-01 01:02:03"), 0, new BigDecimal(2)).addRows(3, 3000L, (short)3, (byte)3, Float.valueOf(3.0f), 3.0, "string_row3", LocalDate.of(2017, 1, 1), LocalTime.of(1, 6, 3), LocalDateTime.of(2017, 1, 1, 1, 6, 3), DateTimeUtils.parseTimestampWithoutTimeZone("2017-01-01 01:06:03"), 0, new BigDecimal(3)).addRows(4, 4000L, (short)4, (byte)4, Float.valueOf(4.0f), 4.0, "\u7b2c\u56db\u884c", LocalDate.of(2017, 1, 1), LocalTime.of(2, 4, 3), LocalDateTime.of(2017, 1, 1, 2, 4, 3), DateTimeUtils.parseTimestampWithoutTimeZone("2017-01-01 02:04:03"), 0, new BigDecimal(4)).getRows();
        monthlyRowsInTableA = TestUtils.RowsBuilder.of(schemaInTableA).addRows(1, 1000L, (short)1, (byte)1, Float.valueOf(1.0f), 1.0, "string_row1", LocalDate.of(2017, 1, 1), LocalTime.of(1, 1, 3), LocalDateTime.of(2017, 1, 1, 1, 1, 3), DateTimeUtils.parseTimestampWithUTCTimeZone("2017-01-01 01:01:03"), 0, new BigDecimal(1)).addRows(2, 2000L, (short)2, (byte)2, Float.valueOf(2.0f), 2.0, "string_row2", LocalDate.of(2017, 1, 1), LocalTime.of(1, 2, 3), LocalDateTime.of(2017, 1, 1, 1, 2, 3), DateTimeUtils.parseTimestampWithUTCTimeZone("2017-02-01 01:02:03"), 0, new BigDecimal(2)).addRows(3, 3000L, (short)3, (byte)3, Float.valueOf(3.0f), 3.0, "string_row3", LocalDate.of(2017, 1, 1), LocalTime.of(1, 6, 3), LocalDateTime.of(2017, 1, 1, 1, 6, 3), DateTimeUtils.parseTimestampWithUTCTimeZone("2017-03-01 01:06:03"), 0, new BigDecimal(3)).getRows();
        schemaFloatDouble = Schema.builder().addFloatField("f_float_1").addDoubleField("f_double_1").addFloatField("f_float_2").addDoubleField("f_double_2").addFloatField("f_float_3").addDoubleField("f_double_3").build();
        rowsOfFloatDouble = TestUtils.RowsBuilder.of(schemaFloatDouble).addRows(Float.valueOf(Float.POSITIVE_INFINITY), Double.POSITIVE_INFINITY, Float.valueOf(Float.NEGATIVE_INFINITY), Double.NEGATIVE_INFINITY, Float.valueOf(Float.NaN), Double.NaN).getRows();
        schemaBytes = Schema.builder().addStringField("f_func").addByteArrayField("f_bytes").build();
        rowsOfBytes = TestUtils.RowsBuilder.of(schemaBytes).addRows("LENGTH", "".getBytes(StandardCharsets.UTF_8), "LENGTH", "\u0430\u0431\u0432\u0433\u0434".getBytes(StandardCharsets.UTF_8), "LENGTH", "\u0000\u0001".getBytes(StandardCharsets.UTF_8), "TO_HEX", "foobar".getBytes(StandardCharsets.UTF_8), "TO_HEX", " ".getBytes(StandardCharsets.UTF_8), "TO_HEX", "abcABC".getBytes(StandardCharsets.UTF_8), "TO_HEX", "abcABC\u0436\u0449\u0444\u0416\u0429\u0424".getBytes(StandardCharsets.UTF_8), "HashingFn", "foobar".getBytes(StandardCharsets.UTF_8), "HashingFn", " ".getBytes(StandardCharsets.UTF_8), "HashingFn", "abcABC\u0436\u0449\u0444\u0416\u0429\u0424".getBytes(StandardCharsets.UTF_8)).getRows();
        schemaBytesPaddingTest = Schema.builder().addNullableField("f_bytes_one", Schema.FieldType.BYTES).addNullableField("length", Schema.FieldType.INT64).addNullableField("f_bytes_two", Schema.FieldType.BYTES).build();
        rowsOfBytesPaddingTest = TestUtils.RowsBuilder.of(schemaBytesPaddingTest).addRows("abcdef".getBytes(StandardCharsets.UTF_8), 0L, "defgh".getBytes(StandardCharsets.UTF_8), "abcdef".getBytes(StandardCharsets.UTF_8), 6L, "defgh".getBytes(StandardCharsets.UTF_8), "abcdef".getBytes(StandardCharsets.UTF_8), 4L, "defgh".getBytes(StandardCharsets.UTF_8), "abcdef".getBytes(StandardCharsets.UTF_8), 10L, "defgh".getBytes(StandardCharsets.UTF_8), "abc".getBytes(StandardCharsets.UTF_8), 10L, "defgh".getBytes(StandardCharsets.UTF_8), "abc".getBytes(StandardCharsets.UTF_8), 7L, "-".getBytes(StandardCharsets.UTF_8), "".getBytes(StandardCharsets.UTF_8), 7L, "def".getBytes(StandardCharsets.UTF_8), null, null, null).getRows();
    }

    @Before
    public void preparePCollections() {
        this.boundedInput1 = (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.of(rowsInTableA).withRowSchema(schemaInTableA));
        this.boundedInput2 = (PCollection)this.pipeline.apply("boundedInput2", (PTransform)Create.of((Object)rowsInTableA.get(0), (Object[])new Row[0]).withRowSchema(schemaInTableA));
        this.boundedInputFloatDouble = (PCollection)this.pipeline.apply("boundedInputFloatDouble", (PTransform)Create.of(rowsOfFloatDouble).withRowSchema(schemaFloatDouble));
        this.boundedInputBytes = (PCollection)this.pipeline.apply("boundedInputBytes", (PTransform)Create.of(rowsOfBytes).withRowSchema(schemaBytes));
        this.boundedInputBytesPaddingTest = (PCollection)this.pipeline.apply("boundedInputBytesPaddingTest", (PTransform)Create.of(rowsOfBytesPaddingTest).withRowSchema(schemaBytesPaddingTest));
        this.boundedInputMonthly = (PCollection)this.pipeline.apply("boundedInputMonthly", (PTransform)Create.of(monthlyRowsInTableA).withRowSchema(schemaInTableA));
        this.unboundedInput1 = this.prepareUnboundedPCollection1();
        this.unboundedInput2 = this.prepareUnboundedPCollection2();
    }

    private PCollection<Row> prepareUnboundedPCollection1() {
        TestStream.Builder values = TestStream.create((Schema)schemaInTableA);
        for (Row row : rowsInTableA) {
            values = values.advanceWatermarkTo(new Instant((Object)row.getDateTime("f_timestamp")));
            values = values.addElements((Object)row, (Object[])new Row[0]);
        }
        return (PCollection)((PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedInput1", (PTransform)values.advanceWatermarkToInfinity())).apply("unboundedInput1.fixedWindow1year", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardDays((long)365L))));
    }

    private PCollection<Row> prepareUnboundedPCollection2() {
        TestStream.Builder values = TestStream.create((Schema)schemaInTableA);
        Row row = rowsInTableA.get(0);
        values = values.advanceWatermarkTo(new Instant((Object)row.getDateTime("f_timestamp")));
        values = values.addElements((Object)row, (Object[])new Row[0]);
        return (PCollection)((PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedInput2", (PTransform)values.advanceWatermarkToInfinity())).apply("unboundedInput2.fixedWindow1year", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardDays((long)365L))));
    }
}

