/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlDslArrayTest {
    private static final Schema INPUT_SCHEMA = Schema.builder().addInt32Field("f_int").addStringField("f_string").addNullableField("f_stringArr", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testSelectArrayValue() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addInt32Field("f_int").addArrayField("f_arr", Schema.FieldType.STRING).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT 42, ARRAY ['aa', 'bb'] as `f_arr` FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{42, Arrays.asList("aa", "bb")}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{42, Arrays.asList("aa", "bb")}).build()});
        this.pipeline.run();
    }

    @Test
    public void testProjectArrayField() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addInt32Field("f_int").addArrayField("f_stringArr", Schema.FieldType.STRING).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_int, f_stringArr FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{1}).addArray(Arrays.asList("111", "222")).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{2}).addArray(Arrays.asList("33", "44", "55")).build()});
        this.pipeline.run();
    }

    @Test
    public void testProjectArrayFieldWithCoGBKJoin() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addNullableField("f_stringArr", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_stringArr FROM PCOLLECTION WHERE f_string IN ('A', 'B', 'ABCAABAAAGAG','ABCAABAAAGCB','ABCAABAAAGCJ','ABCAABAAAGEB','ABCAABAAAGEK','ABCAABAAAGFB','ABCAABAAAGFG','ABCAABABAGBJ','ABCAABABBKIF','ABCAABABCAIK','ABCAABAEJAAF','ABCAABAEJAED','ABCAABAEJAEE','ABCAABAEJAEF','ABCIABAAAGGJ','ABCIABAAAGKB','ABCIABAAAJBC','ABCIABAAAJCD','ABCIABAAAJEK','ABCIABAAAJFE','ABCIABAAAJGE','ABCIABAAAJGF','ABCIABAAAJGG','ABCIABAAAJJK','ABCIABAABAGK','ABCIABAABAKD','ABCIABAABBDI','ABCIABAABBEI','ABCIABAABFBB','ABCIABAABFBJ','ABCIABAABFCC','ABCIABAABFDI','ABCIABACFBKF','ABCIABAJAIBG','ABCIABBBDAAC','ABCIABBFJGAD','ABCIABBGJFDK','ABCIABCAAFBB','ABCIABCAAFJC','ABCIABCACADA','ABGDABAAGFGA','ABGDABAAGFGF','ABGDABAAGFJG','ABGDABAAGFJK','ABGDABAAGFKJ','ABGDABAAGFKI')"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addArray(Arrays.asList("111", "222")).build(), Row.withSchema((Schema)resultType).addArray(Arrays.asList("33", "44", "55")).build()});
        this.pipeline.run();
    }

    @Test
    public void testAccessArrayElement() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addStringField("f_arrElem").build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_stringArr[1] FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{"111"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{"33"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testSingleElement() throws Exception {
        Row inputRow = Row.withSchema((Schema)INPUT_SCHEMA).addValues(new Object[]{1, "A"}).addArray(Arrays.asList("111")).build();
        PCollection input = (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.of((Object)inputRow, (Object[])new Row[0]).withRowSchema(INPUT_SCHEMA));
        Schema resultType = Schema.builder().addStringField("f_arrElem").build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT ELEMENT(f_stringArr) FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{"111"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testCardinality() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addInt32Field("f_size").build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT CARDINALITY(f_stringArr) FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{2}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{3}).build()});
        this.pipeline.run();
    }

    @Test
    public void testUnnestLiteral() {
        PCollection input = (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(Row.class)).withRowSchema(INPUT_SCHEMA));
        TupleTag<Row> mainTag = new TupleTag<Row>("main"){};
        PCollectionTuple inputTuple = PCollectionTuple.of((TupleTag)mainTag, (PCollection)input);
        Schema resultType = Schema.builder().addStringField("f_string").build();
        PCollection result = (PCollection)inputTuple.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT * FROM UNNEST (ARRAY ['a', 'b', 'c'])"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{"a"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{"b"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{"c"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testUnnestNamedLiteral() {
        PCollection input = (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(Row.class)).withRowSchema(INPUT_SCHEMA));
        TupleTag<Row> mainTag = new TupleTag<Row>("main"){};
        PCollectionTuple inputTuple = PCollectionTuple.of((TupleTag)mainTag, (PCollection)input);
        Schema resultType = Schema.builder().addStringField("f_string").build();
        PCollection result = (PCollection)inputTuple.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT * FROM UNNEST (ARRAY ['a', 'b', 'c']) AS t(f_string)"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{"a"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{"b"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{"c"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testUnnestCrossJoin() {
        Row row1 = Row.withSchema((Schema)INPUT_SCHEMA).addValues(new Object[]{42, "S"}).addArray(Arrays.asList("111", "222", "333")).build();
        Row row2 = Row.withSchema((Schema)INPUT_SCHEMA).addValues(new Object[]{13, "T"}).addArray(Arrays.asList("444", "555")).build();
        PCollection input = (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.of((Object)row1, (Object[])new Row[]{row2}).withRowSchema(INPUT_SCHEMA));
        TupleTag<Row> mainTag = new TupleTag<Row>("main"){};
        PCollectionTuple inputTuple = PCollectionTuple.of((TupleTag)mainTag, (PCollection)input);
        Schema resultType = Schema.builder().addInt32Field("f_int").addStringField("f_string").build();
        PCollection result = (PCollection)inputTuple.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_int, arrElems.f_string FROM main  CROSS JOIN UNNEST (main.f_stringArr) AS arrElems(f_string)"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{42, "111"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{42, "222"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{42, "333"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{13, "444"}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{13, "555"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testSelectRowsFromArrayOfRows() {
        Schema elementSchema = Schema.builder().addStringField("f_rowString").addInt32Field("f_rowInt").build();
        Schema resultSchema = Schema.builder().addArrayField("f_resultArray", Schema.FieldType.row((Schema)elementSchema)).build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addArrayField("f_arrayOfRows", Schema.FieldType.row((Schema)elementSchema)).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).addValues(new Object[]{1, Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"AA", 11}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"BB", 22}).build())}).build(), (Object[])new Row[]{Row.withSchema((Schema)inputType).addValues(new Object[]{2, Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"CC", 33}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"DD", 44}).build())}).build()}).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_arrayOfRows FROM PCOLLECTION"))).setRowSchema(resultSchema);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addArray(Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"AA", 11}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"BB", 22}).build())).build(), Row.withSchema((Schema)resultSchema).addArray(Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"CC", 33}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"DD", 44}).build())).build()});
        this.pipeline.run();
    }

    @Test
    public void testSelectSingleRowFromArrayOfRows() {
        Schema elementSchema = Schema.builder().addStringField("f_rowString").addInt32Field("f_rowInt").build();
        Schema resultSchema = Schema.builder().addRowField("row", elementSchema).build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addArrayField("f_arrayOfRows", Schema.FieldType.row((Schema)elementSchema)).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).addValues(new Object[]{1, Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"AA", 11}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"BB", 22}).build())}).build(), (Object[])new Row[]{Row.withSchema((Schema)inputType).addValues(new Object[]{2, Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"CC", 33}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"DD", 44}).build())}).build()}).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_arrayOfRows[2] FROM PCOLLECTION"))).setRowSchema(resultSchema);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addValues(new Object[]{Row.withSchema((Schema)elementSchema).addValues(new Object[]{"BB", 22}).build()}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{Row.withSchema((Schema)elementSchema).addValues(new Object[]{"DD", 44}).build()}).build()});
        this.pipeline.run();
    }

    @Test
    public void testSelectRowFieldFromArrayOfRows() {
        Schema elementSchema = Schema.builder().addStringField("f_rowString").addInt32Field("f_rowInt").build();
        Schema resultSchema = Schema.builder().addStringField("f_stringField").build();
        Schema inputType = Schema.builder().addInt32Field("f_int").addArrayField("f_arrayOfRows", Schema.FieldType.row((Schema)elementSchema)).build();
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)inputType).addValues(new Object[]{1, Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"AA", 11}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"BB", 22}).build())}).build(), (Object[])new Row[]{Row.withSchema((Schema)inputType).addValues(new Object[]{2, Arrays.asList(Row.withSchema((Schema)elementSchema).addValues(new Object[]{"CC", 33}).build(), Row.withSchema((Schema)elementSchema).addValues(new Object[]{"DD", 44}).build())}).build()}).withRowSchema(inputType));
        PCollection result = ((PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_arrayOfRows[2].f_rowString FROM PCOLLECTION"))).setRowSchema(resultSchema);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultSchema).addValues(new Object[]{"BB"}).build(), Row.withSchema((Schema)resultSchema).addValues(new Object[]{"DD"}).build()});
        this.pipeline.run();
    }

    private PCollection<Row> pCollectionOf2Elements() {
        return (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.of((Object)Row.withSchema((Schema)INPUT_SCHEMA).addValues(new Object[]{1, "A"}).addArray(Arrays.asList("111", "222")).build(), (Object[])new Row[]{Row.withSchema((Schema)INPUT_SCHEMA).addValues(new Object[]{2, "B"}).addArray(Arrays.asList("33", "44", "55")).build()}).withRowSchema(INPUT_SCHEMA));
    }
}

