/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.utils.RowAsserts;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BeamSqlDslAggregationNullableTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    private PCollection<Row> boundedInput;

    @Before
    public void setUp() {
        Schema schema = Schema.builder().addNullableField("f_int1", Schema.FieldType.INT32).addNullableField("f_int2", Schema.FieldType.INT32).addInt32Field("f_int3").build();
        List<Row> rows = TestUtils.RowsBuilder.of(schema).addRows(1, 5, 1).addRows(null, 1, 1).addRows(2, 1, 1).addRows(null, 1, 1).addRows(null, null, 1).addRows(null, null, 1).addRows(3, 2, 1).getRows();
        this.boundedInput = (PCollection)PBegin.in((Pipeline)this.pipeline).apply((PTransform)Create.of(rows).withRowSchema(schema));
    }

    @Test
    public void testCount() {
        String sql = "SELECT COUNT(f_int1) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(3L));
        this.pipeline.run();
    }

    @Test
    public void testCountNull() {
        String sql = "SELECT COUNT(f_int1) FROM PCOLLECTION WHERE f_int2 IS NULL GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(0L));
        this.pipeline.run();
    }

    @Test
    public void testCountStar() {
        String sql = "SELECT COUNT(*) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(7L));
        this.pipeline.run();
    }

    @Test
    public void testCountThroughSum() {
        String sql = "SELECT SUM(CASE f_int1 IS NOT NULL WHEN TRUE THEN 1 ELSE 0 END) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(3));
        this.pipeline.run();
    }

    @Test
    public void testCountNulls() {
        String sql = "SELECT SUM(CASE f_int1 IS NULL WHEN TRUE THEN 1 ELSE 0 END) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(4));
        this.pipeline.run();
    }

    @Test
    public void testSum() {
        String sql = "SELECT SUM(f_int1) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(6));
        this.pipeline.run();
    }

    @Test
    public void testSumNull() {
        String sql = "SELECT SUM(f_int1) FROM PCOLLECTION WHERE f_int2 IS NULL GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesNull());
        this.pipeline.run();
    }

    @Test
    public void testMin() {
        String sql = "SELECT MIN(f_int1) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(1));
        this.pipeline.run();
    }

    @Test
    public void testMinNull() {
        String sql = "SELECT MIN(f_int1) FROM PCOLLECTION WHERE f_int2 IS NULL GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesNull());
        this.pipeline.run();
    }

    @Test
    public void testMax() {
        String sql = "SELECT MAX(f_int1) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(3));
        this.pipeline.run();
    }

    @Test
    public void testMaxNull() {
        String sql = "SELECT MAX(f_int1) FROM PCOLLECTION WHERE f_int2 IS NULL GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesNull());
        this.pipeline.run();
    }

    @Test
    public void testAvg() {
        String sql = "SELECT AVG(f_int1) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(2));
        this.pipeline.run();
    }

    @Test
    public void testAvgNull() {
        String sql = "SELECT AVG(f_int1) FROM PCOLLECTION WHERE f_int2 IS NULL GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesNull());
        this.pipeline.run();
    }

    @Test
    public void testAvgGroupByNullable() {
        String sql = "SELECT AVG(f_int1), f_int2 FROM PCOLLECTION GROUP BY f_int2";
        PCollection out = (PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql));
        Schema schema = out.getSchema();
        PAssert.that((PCollection)out).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValues(new Object[]{null, null}).build(), Row.withSchema((Schema)schema).addValues(new Object[]{2, 1}).build(), Row.withSchema((Schema)schema).addValues(new Object[]{1, 5}).build(), Row.withSchema((Schema)schema).addValues(new Object[]{3, 2}).build()});
        this.pipeline.run();
    }

    @Test
    public void testCountGroupByNullable() {
        String sql = "SELECT COUNT(f_int1) as c, f_int2 FROM PCOLLECTION GROUP BY f_int2";
        PCollection out = (PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql));
        Schema schema = out.getSchema();
        PAssert.that((PCollection)out).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValues(new Object[]{0L, null}).build(), Row.withSchema((Schema)schema).addValues(new Object[]{1L, 1}).build(), Row.withSchema((Schema)schema).addValues(new Object[]{1L, 5}).build(), Row.withSchema((Schema)schema).addValues(new Object[]{1L, 2}).build()});
        Assert.assertEquals((Object)Schema.builder().addInt64Field("c").addNullableField("f_int2", Schema.FieldType.INT32).build(), (Object)schema);
        this.pipeline.run();
    }

    @Test
    public void testSampleVariance() {
        String sql = "SELECT COVAR_SAMP(f_int1, f_int2) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(-1));
        this.pipeline.run();
    }

    @Test
    public void testSampleVarianceReverse() {
        String sql = "SELECT COVAR_SAMP(f_int2, f_int1) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(-1));
        this.pipeline.run();
    }
}

