/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.BeamSqlCli;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.extensions.sql.utils.DateTimeUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlCliTest {
    @Test
    public void testExecute_createTextTable() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_createTableWithPrefixArrayField() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age', \ntags ARRAY<VARCHAR>, \nmatrix ARRAY<ARRAY<INTEGER>> \n) \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true), Schema.Field.of((String)"tags", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)CalciteUtils.VARCHAR)).withNullable(true), Schema.Field.of((String)"matrix", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)CalciteUtils.INTEGER))).withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_createTableWithPrefixMapField() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age', \ntags MAP<VARCHAR, VARCHAR>, \nnestedMap MAP<INTEGER, MAP<VARCHAR, INTEGER>> \n) \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true), Schema.Field.of((String)"tags", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)CalciteUtils.VARCHAR, (Schema.FieldType)CalciteUtils.VARCHAR)).withNullable(true), Schema.Field.of((String)"nestedMap", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)CalciteUtils.INTEGER, (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)CalciteUtils.VARCHAR, (Schema.FieldType)CalciteUtils.INTEGER))).withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_createTableWithRowField() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age', \naddress ROW ( \n  street VARCHAR, \n  country VARCHAR \n  ), \naddressAngular ROW< \n  street VARCHAR, \n  country VARCHAR \n  >, \nisRobot BOOLEAN) \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true), Schema.Field.of((String)"address", (Schema.FieldType)Schema.FieldType.row((Schema)Schema.builder().addNullableField("street", CalciteUtils.VARCHAR).addNullableField("country", CalciteUtils.VARCHAR).build())).withNullable(true), Schema.Field.of((String)"addressAngular", (Schema.FieldType)Schema.FieldType.row((Schema)Schema.builder().addNullableField("street", CalciteUtils.VARCHAR).addNullableField("country", CalciteUtils.VARCHAR).build())).withNullable(true), Schema.Field.of((String)"isRobot", (Schema.FieldType)CalciteUtils.BOOLEAN).withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_dropTable() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        cli.execute("drop table person");
        table = (Table)metaStore.getTables().get("person");
        Assert.assertNull((Object)table);
    }

    @Test(expected=ParseException.class)
    public void testExecute_dropTable_assertTableRemovedFromPlanner() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        cli.execute("drop table person");
        cli.explainQuery("select * from person");
    }

    @Test
    public void testExplainQuery() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        String plan = cli.explainQuery("select * from person");
        MatcherAssert.assertThat((Object)plan, (Matcher)Matchers.equalTo((Object)"BeamCalcRel(expr#0..2=[{inputs}], proj#0..2=[{exprs}])\n  BeamIOSourceRel(table=[[beam, person]])\n"));
    }

    @Test
    public void test_time_types() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        TestTableProvider testTableProvider = new TestTableProvider();
        metaStore.registerProvider((TableProvider)testTableProvider);
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("CREATE EXTERNAL TABLE test_table (\nf_date DATE, \nf_time TIME, \nf_ts TIMESTAMP) \nTYPE 'test'");
        cli.execute("INSERT INTO test_table VALUES (DATE '2018-11-01', TIME '15:23:59', TIMESTAMP '2018-07-01 21:26:07.123' )");
        Table table = (Table)metaStore.getTables().get("test_table");
        Assert.assertNotNull((Object)table);
        TestTableProvider.TableWithRows tableWithRows = (TestTableProvider.TableWithRows)testTableProvider.tables().get(table.getName());
        Assert.assertEquals((long)1L, (long)tableWithRows.getRows().size());
        Row row = (Row)tableWithRows.getRows().get(0);
        Assert.assertEquals((long)3L, (long)row.getFieldCount());
        Assert.assertEquals((Object)"2018-11-01", (Object)((LocalDate)row.getLogicalTypeValue("f_date", LocalDate.class)).toString());
        Assert.assertEquals((Object)"15:23:59", (Object)((LocalTime)row.getLogicalTypeValue("f_time", LocalTime.class)).toString());
        Assert.assertEquals((Object)DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:07.123"), (Object)row.getDateTime("f_ts"));
    }
}

