/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.time.LocalDate;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlCastTest {
    private static final Schema INPUT_ROW_SCHEMA = Schema.builder().addInt32Field("f_int").addStringField("f_string").build();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testCastToDate() {
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)INPUT_ROW_SCHEMA).addValues(new Object[]{1}).addValue((Object)"20181018").build(), (Object[])new Row[0]).withRowSchema(INPUT_ROW_SCHEMA));
        Schema resultType = Schema.builder().addInt32Field("f_int").addNullableField("f_date", CalciteUtils.DATE).build();
        PCollection result = (PCollection)input.apply((PTransform)SqlTransform.query((String)"SELECT f_int, \n   CAST( \n     SUBSTRING(TRIM(f_string) FROM 1 FOR 4) \n      ||'-' \n      ||SUBSTRING(TRIM(f_string) FROM 5 FOR 2) \n      ||'-' \n      ||SUBSTRING(TRIM(f_string) FROM 7 FOR 2) as DATE) \nFROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{1, LocalDate.of(2018, 10, 18)}).build()});
        this.pipeline.run();
    }

    @Test
    public void testCastToDateWithCase() {
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)Row.withSchema((Schema)INPUT_ROW_SCHEMA).addValues(new Object[]{1}).addValue((Object)"20181018").build(), (Object[])new Row[0]).withRowSchema(INPUT_ROW_SCHEMA));
        Schema resultType = Schema.builder().addInt32Field("f_int").addLogicalTypeField("f_date", SqlTypes.DATE).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_int, \nCASE WHEN CHAR_LENGTH(TRIM(f_string)) = 8 \n    THEN CAST (\n       SUBSTRING(TRIM(f_string) FROM 1 FOR 4) \n        ||'-' \n        ||SUBSTRING(TRIM(f_string) FROM 5 FOR 2) \n        ||'-' \n        ||SUBSTRING(TRIM(f_string) FROM 7 FOR 2) AS DATE)\n    ELSE DATE '2001-01-01'\nEND \nFROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{1, LocalDate.of(2018, 10, 18)}).build()});
        this.pipeline.run();
    }
}

