/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Test;

public class BeamAnalyticFunctionsTest
extends BeamSqlDslBase {
    private PCollection<Row> inputData() {
        Schema schema = Schema.builder().addStringField("item").addStringField("category").addInt32Field("purchases").build();
        return ((PCollection)this.pipeline.apply((PTransform)Create.of(TestUtils.rowsBuilderOf(schema).addRows("kale", "vegetable", 23, "orange", "fruit", 2, "cabbage", "vegetable", 9, "apple", "fruit", 8, "leek", "vegetable", 2, "lettuce", "vegetable", 10).getRows()))).setRowSchema(schema);
    }

    private PCollection<Row> inputData2() {
        Schema schema = Schema.builder().addInt32Field("x").build();
        return ((PCollection)this.pipeline.apply((PTransform)Create.of(TestUtils.rowsBuilderOf(schema).addRows(1, 2, 2, 5, 8, 10, 10).getRows()))).setRowSchema(schema);
    }

    @Test
    public void testOverCumulativeSum() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, sum(purchases) over (PARTITION BY category ORDER BY purchases ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 2, "apple", 8, "fruit", 10, "leek", 2, "vegetable", 2, "cabbage", 9, "vegetable", 11, "lettuce", 10, "vegetable", 21, "kale", 23, "vegetable", 44).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testOverRowsBoundedSum() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, sum(purchases) over (PARTITION BY category ORDER BY purchases ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 10, "apple", 8, "fruit", 10, "leek", 2, "vegetable", 11, "cabbage", 9, "vegetable", 21, "lettuce", 10, "vegetable", 42, "kale", 23, "vegetable", 33).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testOverRangeBoundedSum() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, sum(purchases) over (PARTITION BY category ORDER BY purchases RANGE BETWEEN 1 PRECEDING AND 1 FOLLOWING) as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 2, "apple", 8, "fruit", 8, "leek", 2, "vegetable", 2, "cabbage", 9, "vegetable", 19, "lettuce", 10, "vegetable", 19, "kale", 23, "vegetable", 23).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testOverCumulativeSumOrderByDesc() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, sum(purchases) over (PARTITION BY category ORDER BY purchases DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 10, "apple", 8, "fruit", 8, "leek", 2, "vegetable", 44, "cabbage", 9, "vegetable", 42, "lettuce", 10, "vegetable", 33, "kale", 23, "vegetable", 23).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testSimpleOverFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, sum(purchases) over () as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 54, "apple", 8, "fruit", 54, "leek", 2, "vegetable", 54, "cabbage", 9, "vegetable", 54, "lettuce", 10, "vegetable", 54, "kale", 23, "vegetable", 54).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testFirstValueFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, FIRST_VALUE(purchases) over (PARTITION BY category ORDER BY purchases ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 2, "apple", 8, "fruit", 2, "leek", 2, "vegetable", 2, "cabbage", 9, "vegetable", 2, "lettuce", 10, "vegetable", 2, "kale", 23, "vegetable", 2).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testLastValueFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData();
        String sql = "SELECT item, purchases, category, LAST_VALUE(purchases) over (PARTITION BY category ORDER BY purchases ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) as total_purchases  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addStringField("item").addInt32Field("purchases").addStringField("category").addInt32Field("total_purchases").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows("orange", 2, "fruit", 2, "apple", 8, "fruit", 8, "leek", 2, "vegetable", 2, "cabbage", 9, "vegetable", 9, "lettuce", 10, "vegetable", 10, "kale", 23, "vegetable", 23).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testRowNumberFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData2();
        String sql = "SELECT x, ROW_NUMBER() over (ORDER BY x ) as agg  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addInt32Field("x").addInt64Field("agg").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows(1, 1L, 2, 2L, 2, 3L, 5, 4L, 8, 5L, 10, 6L, 10, 7L).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testDenseRankFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData2();
        String sql = "SELECT x, DENSE_RANK() over (ORDER BY x ) as agg  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addInt32Field("x").addInt64Field("agg").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows(1, 1L, 2, 2L, 2, 2L, 5, 3L, 8, 4L, 10, 5L, 10, 5L).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testRankFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData2();
        String sql = "SELECT x, RANK() over (ORDER BY x ) as agg  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addInt32Field("x").addInt64Field("agg").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows(1, 1L, 2, 2L, 2, 2L, 5, 4L, 8, 5L, 10, 6L, 10, 6L).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }

    @Test
    public void testPercentRankFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PCollection<Row> inputRows = this.inputData2();
        String sql = "SELECT x, PERCENT_RANK() over (ORDER BY x ) as agg  FROM PCOLLECTION";
        PCollection result = (PCollection)inputRows.apply("sql", (PTransform)SqlTransform.query((String)sql));
        Schema overResultSchema = Schema.builder().addInt32Field("x").addDoubleField("agg").build();
        List<Row> overResult = TestUtils.RowsBuilder.of(overResultSchema).addRows(1, 0.0, 2, 0.16666666666666666, 2, 0.16666666666666666, 5, 0.5, 8, 0.6666666666666666, 10, 0.8333333333333334, 10, 0.8333333333333334).getRows();
        PAssert.that((PCollection)result).containsInAnyOrder(overResult);
        this.pipeline.run();
    }
}

