/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsub;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubJsonTableProvider;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.schemas.transforms.DropFields;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Experimental
public class RowToPubsubMessage
extends PTransform<PCollection<Row>, PCollection<PubsubMessage>> {
    private final PubsubJsonTableProvider.PubsubIOTableConfiguration config;

    private RowToPubsubMessage(PubsubJsonTableProvider.PubsubIOTableConfiguration config) {
        Preconditions.checkArgument((boolean)config.getUseFlatSchema(), (Object)"RowToPubsubMessage is only supported for flattened schemas.");
        this.config = config;
    }

    public static RowToPubsubMessage fromTableConfig(PubsubJsonTableProvider.PubsubIOTableConfiguration config) {
        return new RowToPubsubMessage(config);
    }

    public PCollection<PubsubMessage> expand(PCollection<Row> input) {
        PCollection withTimestamp = this.config.useTimestampAttribute() ? (PCollection)input.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)row -> row.getDateTime("event_timestamp").toInstant())) : input;
        return (PCollection)((PCollection)((PCollection)withTimestamp.apply((PTransform)DropFields.fields((String[])new String[]{"event_timestamp"}))).apply((PTransform)ToJson.of())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via((SerializableFunction & Serializable)json -> new PubsubMessage(json.getBytes(StandardCharsets.ISO_8859_1), (Map)ImmutableMap.of())));
    }
}

