/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamIOType;
import org.apache.beam.sdk.extensions.sql.mock.MockedTable;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Pair;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class MockedUnboundedTable
extends MockedTable {
    private final List<Pair<Duration, List<BeamRecord>>> timestampedRows = new ArrayList<Pair<Duration, List<BeamRecord>>>();
    private int timestampField;

    private MockedUnboundedTable(BeamRecordSqlType beamSqlRowType) {
        super(beamSqlRowType);
    }

    public static MockedUnboundedTable of(Object ... args) {
        return new MockedUnboundedTable(TestUtils.buildBeamSqlRowType(args));
    }

    public MockedUnboundedTable timestampColumnIndex(int idx) {
        this.timestampField = idx;
        return this;
    }

    public MockedUnboundedTable addRows(Duration duration, Object ... args) {
        List<BeamRecord> rows = TestUtils.buildRows(this.getRowType(), Arrays.asList(args));
        this.timestampedRows.add((Pair<Duration, List<BeamRecord>>)Pair.of((Object)duration, rows));
        return this;
    }

    public BeamIOType getSourceType() {
        return BeamIOType.UNBOUNDED;
    }

    public PCollection<BeamRecord> buildIOReader(Pipeline pipeline) {
        TestStream.Builder values = TestStream.create((Coder)this.beamSqlRowType.getRecordCoder());
        for (Pair<Duration, List<BeamRecord>> pair : this.timestampedRows) {
            values = values.advanceWatermarkTo(new Instant(0L).plus((ReadableDuration)pair.getKey()));
            for (int i = 0; i < ((List)pair.getValue()).size(); ++i) {
                values = values.addElements(TimestampedValue.of(((List)pair.getValue()).get(i), (Instant)new Instant((Object)((BeamRecord)((List)pair.getValue()).get(i)).getDate(this.timestampField))), new TimestampedValue[0]);
            }
        }
        return (PCollection)pipeline.begin().apply("MockedUnboundedTable_" + COUNTER.incrementAndGet(), (PTransform)values.advanceWatermarkToInfinity());
    }
}

