/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamIOType;
import org.apache.beam.sdk.extensions.sql.mock.MockedTable;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

public class MockedBoundedTable
extends MockedTable {
    private static final ConcurrentLinkedQueue<BeamRecord> CONTENT = new ConcurrentLinkedQueue();
    private final List<BeamRecord> rows = new ArrayList<BeamRecord>();

    public MockedBoundedTable(BeamRecordSqlType beamSqlRowType) {
        super(beamSqlRowType);
    }

    public static MockedBoundedTable of(Object ... args) {
        return new MockedBoundedTable(TestUtils.buildBeamSqlRowType(args));
    }

    public static MockedBoundedTable of(BeamRecordSqlType type) {
        return new MockedBoundedTable(type);
    }

    public MockedBoundedTable addRows(Object ... args) {
        List<BeamRecord> rows = TestUtils.buildRows(this.getRowType(), Arrays.asList(args));
        this.rows.addAll(rows);
        return this;
    }

    public BeamIOType getSourceType() {
        return BeamIOType.BOUNDED;
    }

    public PCollection<BeamRecord> buildIOReader(Pipeline pipeline) {
        return (PCollection)PBegin.in((Pipeline)pipeline).apply("MockedBoundedTable_Reader_" + COUNTER.incrementAndGet(), (PTransform)Create.of(this.rows));
    }

    @Override
    public PTransform<? super PCollection<BeamRecord>, PDone> buildIOWriter() {
        return new OutputStore();
    }

    public static class OutputStore
    extends PTransform<PCollection<BeamRecord>, PDone> {
        public PDone expand(PCollection<BeamRecord> input) {
            input.apply((PTransform)ParDo.of((DoFn)new DoFn<BeamRecord, Void>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    CONTENT.add(c.element());
                }

                @DoFn.Teardown
                public void close() {
                    CONTENT.clear();
                }
            }));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }
}

