/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.integrationtest;

import java.math.BigDecimal;
import java.util.Random;
import org.apache.beam.sdk.extensions.sql.integrationtest.BeamSqlBuiltinFunctionsIntegrationTestBase;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.SqlFunctions;
import org.junit.Test;

public class BeamSqlMathFunctionsIntegrationTest
extends BeamSqlBuiltinFunctionsIntegrationTestBase {
    private static final int INTEGER_VALUE = 1;
    private static final long LONG_VALUE = 1L;
    private static final short SHORT_VALUE = 1;
    private static final byte BYTE_VALUE = 1;
    private static final double DOUBLE_VALUE = 1.0;
    private static final float FLOAT_VALUE = 1.0f;
    private static final BigDecimal DECIMAL_VALUE = new BigDecimal(1);

    @Test
    public void testAbs() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("ABS(c_integer)", Math.abs(1)).addExpr("ABS(c_bigint)", Math.abs(1L)).addExpr("ABS(c_smallint)", (short)Math.abs(1)).addExpr("ABS(c_tinyint)", (byte)Math.abs(1)).addExpr("ABS(c_double)", Math.abs(1.0)).addExpr("ABS(c_float)", Float.valueOf(Math.abs(1.0f))).addExpr("ABS(c_decimal)", new BigDecimal(Math.abs(DECIMAL_VALUE.doubleValue())));
        checker.buildRunAndCheck();
    }

    @Test
    public void testSqrt() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("SQRT(c_integer)", Math.sqrt(1.0)).addExpr("SQRT(c_bigint)", Math.sqrt(1.0)).addExpr("SQRT(c_smallint)", Math.sqrt(1.0)).addExpr("SQRT(c_tinyint)", Math.sqrt(1.0)).addExpr("SQRT(c_double)", Math.sqrt(1.0)).addExpr("SQRT(c_float)", Math.sqrt(1.0)).addExpr("SQRT(c_decimal)", Math.sqrt(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testRound() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("ROUND(c_integer, 0)", SqlFunctions.sround((int)1, (int)0)).addExpr("ROUND(c_bigint, 0)", SqlFunctions.sround((long)1L, (int)0)).addExpr("ROUND(c_smallint, 0)", (short)SqlFunctions.sround((int)1, (int)0)).addExpr("ROUND(c_tinyint, 0)", (byte)SqlFunctions.sround((int)1, (int)0)).addExpr("ROUND(c_double, 0)", SqlFunctions.sround((double)1.0, (int)0)).addExpr("ROUND(c_float, 0)", Float.valueOf((float)SqlFunctions.sround((double)1.0, (int)0))).addExpr("ROUND(c_decimal, 0)", new BigDecimal(SqlFunctions.sround((double)DECIMAL_VALUE.doubleValue(), (int)0)));
        checker.buildRunAndCheck();
    }

    @Test
    public void testLn() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("LN(c_integer)", Math.log(1.0)).addExpr("LN(c_bigint)", Math.log(1.0)).addExpr("LN(c_smallint)", Math.log(1.0)).addExpr("LN(c_tinyint)", Math.log(1.0)).addExpr("LN(c_double)", Math.log(1.0)).addExpr("LN(c_float)", Math.log(1.0)).addExpr("LN(c_decimal)", Math.log(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testLog10() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("LOG10(c_integer)", Math.log10(1.0)).addExpr("LOG10(c_bigint)", Math.log10(1.0)).addExpr("LOG10(c_smallint)", Math.log10(1.0)).addExpr("LOG10(c_tinyint)", Math.log10(1.0)).addExpr("LOG10(c_double)", Math.log10(1.0)).addExpr("LOG10(c_float)", Math.log10(1.0)).addExpr("LOG10(c_decimal)", Math.log10(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testExp() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("EXP(c_integer)", Math.exp(1.0)).addExpr("EXP(c_bigint)", Math.exp(1.0)).addExpr("EXP(c_smallint)", Math.exp(1.0)).addExpr("EXP(c_tinyint)", Math.exp(1.0)).addExpr("EXP(c_double)", Math.exp(1.0)).addExpr("EXP(c_float)", Math.exp(1.0)).addExpr("EXP(c_decimal)", Math.exp(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testAcos() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("ACOS(c_integer)", Math.acos(1.0)).addExpr("ACOS(c_bigint)", Math.acos(1.0)).addExpr("ACOS(c_smallint)", Math.acos(1.0)).addExpr("ACOS(c_tinyint)", Math.acos(1.0)).addExpr("ACOS(c_double)", Math.acos(1.0)).addExpr("ACOS(c_float)", Math.acos(1.0)).addExpr("ACOS(c_decimal)", Math.acos(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testAsin() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("ASIN(c_integer)", Math.asin(1.0)).addExpr("ASIN(c_bigint)", Math.asin(1.0)).addExpr("ASIN(c_smallint)", Math.asin(1.0)).addExpr("ASIN(c_tinyint)", Math.asin(1.0)).addExpr("ASIN(c_double)", Math.asin(1.0)).addExpr("ASIN(c_float)", Math.asin(1.0)).addExpr("ASIN(c_decimal)", Math.asin(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testAtan() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("ATAN(c_integer)", Math.atan(1.0)).addExpr("ATAN(c_bigint)", Math.atan(1.0)).addExpr("ATAN(c_smallint)", Math.atan(1.0)).addExpr("ATAN(c_tinyint)", Math.atan(1.0)).addExpr("ATAN(c_double)", Math.atan(1.0)).addExpr("ATAN(c_float)", Math.atan(1.0)).addExpr("ATAN(c_decimal)", Math.atan(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testCot() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("COT(c_integer)", 1.0 / Math.tan(1.0)).addExpr("COT(c_bigint)", 1.0 / Math.tan(1.0)).addExpr("COT(c_smallint)", 1.0 / Math.tan(1.0)).addExpr("COT(c_tinyint)", 1.0 / Math.tan(1.0)).addExpr("COT(c_double)", 1.0 / Math.tan(1.0)).addExpr("COT(c_float)", 1.0 / Math.tan(1.0)).addExpr("COT(c_decimal)", 1.0 / Math.tan(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testDegrees() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("DEGREES(c_integer)", Math.toDegrees(1.0)).addExpr("DEGREES(c_bigint)", Math.toDegrees(1.0)).addExpr("DEGREES(c_smallint)", Math.toDegrees(1.0)).addExpr("DEGREES(c_tinyint)", Math.toDegrees(1.0)).addExpr("DEGREES(c_double)", Math.toDegrees(1.0)).addExpr("DEGREES(c_float)", Math.toDegrees(1.0)).addExpr("DEGREES(c_decimal)", Math.toDegrees(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testRadians() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("RADIANS(c_integer)", Math.toRadians(1.0)).addExpr("RADIANS(c_bigint)", Math.toRadians(1.0)).addExpr("RADIANS(c_smallint)", Math.toRadians(1.0)).addExpr("RADIANS(c_tinyint)", Math.toRadians(1.0)).addExpr("RADIANS(c_double)", Math.toRadians(1.0)).addExpr("RADIANS(c_float)", Math.toRadians(1.0)).addExpr("RADIANS(c_decimal)", Math.toRadians(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testCos() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("COS(c_integer)", Math.cos(1.0)).addExpr("COS(c_bigint)", Math.cos(1.0)).addExpr("COS(c_smallint)", Math.cos(1.0)).addExpr("COS(c_tinyint)", Math.cos(1.0)).addExpr("COS(c_double)", Math.cos(1.0)).addExpr("COS(c_float)", Math.cos(1.0)).addExpr("COS(c_decimal)", Math.cos(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testSin() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("SIN(c_integer)", Math.sin(1.0)).addExpr("SIN(c_bigint)", Math.sin(1.0)).addExpr("SIN(c_smallint)", Math.sin(1.0)).addExpr("SIN(c_tinyint)", Math.sin(1.0)).addExpr("SIN(c_double)", Math.sin(1.0)).addExpr("SIN(c_float)", Math.sin(1.0)).addExpr("SIN(c_decimal)", Math.sin(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testTan() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("TAN(c_integer)", Math.tan(1.0)).addExpr("TAN(c_bigint)", Math.tan(1.0)).addExpr("TAN(c_smallint)", Math.tan(1.0)).addExpr("TAN(c_tinyint)", Math.tan(1.0)).addExpr("TAN(c_double)", Math.tan(1.0)).addExpr("TAN(c_float)", Math.tan(1.0)).addExpr("TAN(c_decimal)", Math.tan(DECIMAL_VALUE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testSign() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("SIGN(c_integer)", Integer.signum(1)).addExpr("SIGN(c_bigint)", Long.signum(1L)).addExpr("SIGN(c_smallint)", (short)Integer.signum(1)).addExpr("SIGN(c_tinyint)", (byte)Integer.signum(1)).addExpr("SIGN(c_double)", Math.signum(1.0)).addExpr("SIGN(c_float)", Float.valueOf(Math.signum(1.0f))).addExpr("SIGN(c_decimal)", BigDecimal.valueOf(DECIMAL_VALUE.signum()));
        checker.buildRunAndCheck();
    }

    @Test
    public void testPower() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("POWER(c_integer, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_bigint, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_smallint, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_tinyint, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_double, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_float, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_decimal, 2)", Math.pow(DECIMAL_VALUE.doubleValue(), 2.0));
        checker.buildRunAndCheck();
    }

    @Test
    public void testPi() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("PI", Math.PI);
        checker.buildRunAndCheck();
    }

    @Test
    public void testAtan2() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("ATAN2(c_integer, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_bigint, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_smallint, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_tinyint, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_double, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_float, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_decimal, 2)", Math.atan2(DECIMAL_VALUE.doubleValue(), 2.0));
        checker.buildRunAndCheck();
    }

    @Test
    public void testTruncate() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("TRUNCATE(c_integer, 2)", SqlFunctions.struncate((int)1, (int)2)).addExpr("TRUNCATE(c_bigint, 2)", SqlFunctions.struncate((long)1L, (int)2)).addExpr("TRUNCATE(c_smallint, 2)", (short)SqlFunctions.struncate((int)1, (int)2)).addExpr("TRUNCATE(c_tinyint, 2)", (byte)SqlFunctions.struncate((int)1, (int)2)).addExpr("TRUNCATE(c_double, 2)", SqlFunctions.struncate((double)1.0, (int)2)).addExpr("TRUNCATE(c_float, 2)", Float.valueOf((float)SqlFunctions.struncate((double)1.0, (int)2))).addExpr("TRUNCATE(c_decimal, 2)", SqlFunctions.struncate((BigDecimal)DECIMAL_VALUE, (int)2));
        checker.buildRunAndCheck();
    }

    @Test
    public void testRand() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("RAND(c_integer)", new Random(1L).nextDouble());
        checker.buildRunAndCheck();
    }

    @Test
    public void testRandInteger() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("RAND_INTEGER(c_integer, c_integer)", new Random(1L).nextInt(1));
        checker.buildRunAndCheck();
    }
}

