/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.integrationtest;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.BeamSql;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Joiner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Pair;
import org.junit.Rule;

public class BeamSqlBuiltinFunctionsIntegrationTestBase {
    private static final Map<Class, Integer> JAVA_CLASS_TO_SQL_TYPE = new HashMap<Class, Integer>();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    protected PCollection<BeamRecord> getTestPCollection() {
        BeamRecordSqlType type = BeamRecordSqlType.create(Arrays.asList("ts", "c_tinyint", "c_smallint", "c_integer", "c_bigint", "c_float", "c_double", "c_decimal", "c_tinyint_max", "c_smallint_max", "c_integer_max", "c_bigint_max"), Arrays.asList(91, -6, 5, 4, -5, 6, 8, 3, -6, 5, 4, -5));
        try {
            return MockedBoundedTable.of(type).addRows(BeamSqlBuiltinFunctionsIntegrationTestBase.parseDate("1986-02-15 11:35:26"), (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigDecimal.ONE, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE).buildIOReader((Pipeline)this.pipeline).setCoder((Coder)type.getRecordCoder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Date parseDate(String str) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdf.parse(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JAVA_CLASS_TO_SQL_TYPE.put(Byte.class, -6);
        JAVA_CLASS_TO_SQL_TYPE.put(Short.class, 5);
        JAVA_CLASS_TO_SQL_TYPE.put(Integer.class, 4);
        JAVA_CLASS_TO_SQL_TYPE.put(Long.class, -5);
        JAVA_CLASS_TO_SQL_TYPE.put(Float.class, 6);
        JAVA_CLASS_TO_SQL_TYPE.put(Double.class, 8);
        JAVA_CLASS_TO_SQL_TYPE.put(BigDecimal.class, 3);
        JAVA_CLASS_TO_SQL_TYPE.put(String.class, 12);
        JAVA_CLASS_TO_SQL_TYPE.put(Date.class, 91);
        JAVA_CLASS_TO_SQL_TYPE.put(Boolean.class, 16);
    }

    public class ExpressionChecker {
        private transient List<Pair<String, Object>> exps = new ArrayList<Pair<String, Object>>();

        public ExpressionChecker addExpr(String expression, Object expectedValue) {
            this.exps.add((Pair<String, Object>)Pair.of((Object)expression, (Object)expectedValue));
            return this;
        }

        private String getSql() {
            ArrayList<Object> expStrs = new ArrayList<Object>();
            for (Pair<String, Object> pair : this.exps) {
                expStrs.add(pair.getKey());
            }
            return "SELECT " + Joiner.on((String)",\n  ").join(expStrs) + " FROM PCOLLECTION";
        }

        public void buildRunAndCheck() {
            PCollection<BeamRecord> inputCollection = BeamSqlBuiltinFunctionsIntegrationTestBase.this.getTestPCollection();
            System.out.println("SQL:>\n" + this.getSql());
            try {
                ArrayList<Object> names = new ArrayList<Object>();
                ArrayList types = new ArrayList();
                ArrayList<Object> values = new ArrayList<Object>();
                for (Pair<String, Object> pair : this.exps) {
                    names.add(pair.getKey());
                    types.add(JAVA_CLASS_TO_SQL_TYPE.get(pair.getValue().getClass()));
                    values.add(pair.getValue());
                }
                PCollection rows = (PCollection)inputCollection.apply((PTransform)BeamSql.query((String)this.getSql()));
                PAssert.that((PCollection)rows).containsInAnyOrder(TestUtils.RowsBuilder.of(BeamRecordSqlType.create(names, types)).addRows(values).getRows());
                inputCollection.getPipeline().run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

