/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.beam.sdk.coders.BeamRecordCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Test;

public class BeamSqlRowCoderTest {
    @Test
    public void encodeAndDecode() throws Exception {
        RelProtoDataType protoRowType = new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory a0) {
                return a0.builder().add("col_tinyint", SqlTypeName.TINYINT).add("col_smallint", SqlTypeName.SMALLINT).add("col_integer", SqlTypeName.INTEGER).add("col_bigint", SqlTypeName.BIGINT).add("col_float", SqlTypeName.FLOAT).add("col_double", SqlTypeName.DOUBLE).add("col_decimal", SqlTypeName.DECIMAL).add("col_string_varchar", SqlTypeName.VARCHAR).add("col_time", SqlTypeName.TIME).add("col_timestamp", SqlTypeName.TIMESTAMP).add("col_boolean", SqlTypeName.BOOLEAN).build();
            }
        };
        BeamRecordSqlType beamSQLRowType = CalciteUtils.toBeamRowType((RelDataType)((RelDataType)protoRowType.apply((Object)new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT))));
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        BeamRecord row = new BeamRecord((BeamRecordType)beamSQLRowType, new Object[]{Byte.valueOf("1"), Short.valueOf("1"), 1, 1L, Float.valueOf(1.1f), 1.1, BigDecimal.ZERO, "hello", calendar, new Date(), true});
        BeamRecordCoder coder = beamSQLRowType.getRecordCoder();
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)row);
    }
}

