/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamValuesRelTest
extends BaseRelTest {
    static BeamSqlEnv sqlEnv = new BeamSqlEnv();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        sqlEnv.registerTable("string_table", (BeamSqlTable)MockedBoundedTable.of(12, "name", 12, "description"));
        sqlEnv.registerTable("int_table", (BeamSqlTable)MockedBoundedTable.of(4, "c0", 4, "c1"));
    }

    @Test
    public void testValues() throws Exception {
        String sql = "insert into string_table(name, description) values ('hello', 'world'), ('james', 'bond')";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(12, "name", 12, "description").addRows("hello", "world", "james", "bond").getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_castInt() throws Exception {
        String sql = "insert into int_table (c0, c1) values(cast(1 as int), cast(2 as int))";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "c0", 4, "c1").addRows(1, 2).getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_onlySelect() throws Exception {
        String sql = "select 1, '1'";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "EXPR$0", 1, "EXPR$1").addRows(1, "1").getRows());
        this.pipeline.run();
    }
}

