/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic;

import java.util.ArrayList;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlDivideExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlMinusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlModExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlMultiplyExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlPlusExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlArithmeticExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testAccept_normal() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TINYINT, (Object)Byte.valueOf("1")));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.MAX_VALUE));
        Assert.assertTrue((boolean)new BeamSqlPlusExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertTrue((boolean)new BeamSqlPlusExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)Float.valueOf(1.1f)));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)1.1));
        Assert.assertTrue((boolean)new BeamSqlPlusExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)Float.valueOf(1.1f)));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"1"));
        Assert.assertFalse((boolean)new BeamSqlPlusExpression(operands).accept());
    }

    @Test
    public void testAccept_exception() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TINYINT, (Object)Byte.valueOf("1")));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.MAX_VALUE));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.MAX_VALUE));
        Assert.assertFalse((boolean)new BeamSqlPlusExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TINYINT, (Object)Byte.valueOf("1")));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        Assert.assertFalse((boolean)new BeamSqlPlusExpression(operands).accept());
    }

    @Test
    public void testPlus() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        Assert.assertEquals((Object)2, (Object)new BeamSqlPlusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlPlusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlPlusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)Float.valueOf(1.1f)));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Float.valueOf(2.1f), (Object)new BeamSqlPlusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)1.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2.1, (Object)new BeamSqlPlusExpression(operands).evaluate(record, null).getValue());
    }

    @Test
    public void testMinus() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        Assert.assertEquals((Object)1, (Object)new BeamSqlMinusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)1L, (Object)new BeamSqlMinusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)1L, (Object)new BeamSqlMinusExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)Float.valueOf(2.1f)));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((double)1.0999999046325684, (double)((Number)new BeamSqlMinusExpression(operands).evaluate(record, null).getValue()).floatValue(), (double)0.1);
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)1.1, (Object)new BeamSqlMinusExpression(operands).evaluate(record, null).getValue());
    }

    @Test
    public void testMultiply() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        Assert.assertEquals((Object)2, (Object)new BeamSqlMultiplyExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlMultiplyExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlMultiplyExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)Float.valueOf(2.1f)));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Float.valueOf(2.1f), (Object)new BeamSqlMultiplyExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2.1, (Object)new BeamSqlMultiplyExpression(operands).evaluate(record, null).getValue());
    }

    @Test
    public void testDivide() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        Assert.assertEquals((Object)2, (Object)new BeamSqlDivideExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlDivideExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlDivideExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)Float.valueOf(2.1f)));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Float.valueOf(2.1f), (Object)new BeamSqlDivideExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)2.1, (Object)new BeamSqlDivideExpression(operands).evaluate(record, null).getValue());
    }

    @Test
    public void testMod() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)3));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        Assert.assertEquals((Object)1, (Object)new BeamSqlModExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)3));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        Assert.assertEquals((Object)1L, (Object)new BeamSqlModExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)3L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        Assert.assertEquals((Object)1L, (Object)new BeamSqlModExpression(operands).evaluate(record, null).getValue());
    }
}

