/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlReinterpretExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlReinterpretExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void accept() throws Exception {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)new Date()));
        Assert.assertTrue((boolean)new BeamSqlReinterpretExpression(operands, SqlTypeName.BIGINT).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)new Date()));
        Assert.assertTrue((boolean)new BeamSqlReinterpretExpression(operands, SqlTypeName.BIGINT).accept());
        operands.clear();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIME, (Object)calendar));
        Assert.assertTrue((boolean)new BeamSqlReinterpretExpression(operands, SqlTypeName.BIGINT).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        Assert.assertFalse((boolean)new BeamSqlReinterpretExpression(operands, SqlTypeName.BIGINT).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIME, (Object)calendar));
        Assert.assertFalse((boolean)new BeamSqlReinterpretExpression(operands, SqlTypeName.TINYINT).accept());
    }

    @Test
    public void evaluate() throws Exception {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        Date d = new Date();
        d.setTime(1000L);
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)d));
        Assert.assertEquals((Object)1000L, (Object)new BeamSqlReinterpretExpression(operands, SqlTypeName.BIGINT).evaluate(record, null).getValue());
    }
}

