/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlInputRefExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlInputRefExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testRefInRange() {
        BeamSqlInputRefExpression ref0 = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0);
        Assert.assertEquals((Object)record.getLong(0), (Object)ref0.evaluate(record, null).getValue());
        BeamSqlInputRefExpression ref1 = new BeamSqlInputRefExpression(SqlTypeName.INTEGER, 1);
        Assert.assertEquals((Object)record.getInteger(1), (Object)ref1.evaluate(record, null).getValue());
        BeamSqlInputRefExpression ref2 = new BeamSqlInputRefExpression(SqlTypeName.DOUBLE, 2);
        Assert.assertEquals((Object)record.getDouble(2), (Object)ref2.evaluate(record, null).getValue());
        BeamSqlInputRefExpression ref3 = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 3);
        Assert.assertEquals((Object)record.getLong(3), (Object)ref3.evaluate(record, null).getValue());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRefOutOfRange() {
        BeamSqlInputRefExpression ref = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 4);
        ref.evaluate(record, null).getValue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeUnMatch() {
        BeamSqlInputRefExpression ref = new BeamSqlInputRefExpression(SqlTypeName.INTEGER, 0);
        ref.evaluate(record, null).getValue();
    }
}

