/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlCastExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeamSqlCastExpressionTest
extends BeamSqlFnExecutorTestBase {
    private List<BeamSqlExpression> operands;

    @Before
    public void setup() {
        this.operands = new ArrayList<BeamSqlExpression>();
    }

    @Test
    public void testForOperands() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"aaa"));
        Assert.assertFalse((boolean)new BeamSqlCastExpression(this.operands, SqlTypeName.BIGINT).accept());
    }

    @Test
    public void testForIntegerToBigintTypeCasting() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)5));
        Assert.assertEquals((long)5L, (long)new BeamSqlCastExpression(this.operands, SqlTypeName.BIGINT).evaluate(record, null).getLong());
    }

    @Test
    public void testForDoubleToBigIntCasting() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)5.45));
        Assert.assertEquals((long)5L, (long)new BeamSqlCastExpression(this.operands, SqlTypeName.BIGINT).evaluate(record, null).getLong());
    }

    @Test
    public void testForIntegerToDateCast() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)20170521));
        Assert.assertEquals((Object)Date.valueOf("2017-05-21"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.DATE).evaluate(record, null).getValue());
    }

    @Test
    public void testyyyyMMddDateFormat() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21"));
        Assert.assertEquals((Object)Date.valueOf("2017-05-21"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.DATE).evaluate(record, null).getValue());
    }

    @Test
    public void testyyMMddDateFormat() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"17.05.21"));
        Assert.assertEquals((Object)Date.valueOf("2017-05-21"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.DATE).evaluate(record, null).getValue());
    }

    @Test
    public void testForTimestampCastExpression() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"17-05-21 23:59:59.989"));
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(record, null).getOutputType());
    }

    @Test
    public void testDateTimeFormatWithMillis() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21 23:59:59.989"));
        Assert.assertEquals((Object)Timestamp.valueOf("2017-05-22 00:00:00.0"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(record, null).getValue());
    }

    @Test
    public void testDateTimeFormatWithTimezone() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21 23:59:59.89079 PST"));
        Assert.assertEquals((Object)Timestamp.valueOf("2017-05-22 00:00:00.0"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(record, null).getValue());
    }

    @Test
    public void testDateTimeFormat() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21 23:59:59"));
        Assert.assertEquals((Object)Timestamp.valueOf("2017-05-21 23:59:59"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(record, null).getValue());
    }

    @Test(expected=RuntimeException.class)
    public void testForCastTypeNotSupported() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIME, (Object)Calendar.getInstance().getTime()));
        Assert.assertEquals((Object)Timestamp.valueOf("2017-05-22 00:00:00.0"), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(record, null).getValue());
    }
}

