/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter;

import java.util.ArrayList;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelDataTypeSystem;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config.Lex;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Context;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Contexts;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Frameworks;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelBuilder;
import org.junit.BeforeClass;

public class BeamSqlFnExecutorTestBase {
    public static RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)BeamQueryPlanner.TYPE_FACTORY);
    public static RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)new VolcanoPlanner(), (RexBuilder)rexBuilder);
    public static final JavaTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    public static RelDataType relDataType;
    public static BeamRecordSqlType beamRowType;
    public static BeamRecord record;
    public static RelBuilder relBuilder;

    @BeforeClass
    public static void prepare() {
        relDataType = TYPE_FACTORY.builder().add("order_id", SqlTypeName.BIGINT).add("site_id", SqlTypeName.INTEGER).add("price", SqlTypeName.DOUBLE).add("order_time", SqlTypeName.BIGINT).build();
        beamRowType = CalciteUtils.toBeamRowType((RelDataType)relDataType);
        record = new BeamRecord((BeamRecordType)beamRowType, new Object[]{1234567L, 0, 8.9, 1234567L});
        SchemaPlus schema = Frameworks.createRootSchema((boolean)true);
        ArrayList<Object> traitDefs = new ArrayList<Object>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(RelCollationTraitDef.INSTANCE);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.MYSQL).build()).defaultSchema(schema).traitDefs(traitDefs).context((Context)Contexts.EMPTY_CONTEXT).ruleSets(BeamRuleSets.getRuleSets()).costFactory(null).typeSystem(BeamRelDataTypeSystem.BEAM_REL_DATATYPE_SYSTEM).build();
        relBuilder = RelBuilder.create((FrameworkConfig)config);
    }
}

