/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.extensions.sql.BeamSql;
import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.junit.Test;

public class BeamSqlDslFilterTest
extends BeamSqlDslBase {
    @Test
    public void testSingleFilterWithBounded() throws Exception {
        this.runSingleFilter((PCollection<BeamRecord>)this.boundedInput1);
    }

    @Test
    public void testSingleFilterWithUnbounded() throws Exception {
        this.runSingleFilter((PCollection<BeamRecord>)this.unboundedInput1);
    }

    private void runSingleFilter(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT * FROM PCOLLECTION WHERE f_int = 1";
        PCollection result = (PCollection)input.apply("testSingleFilter", (PTransform)BeamSql.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{(BeamRecord)recordsInTableA.get(0)});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testCompositeFilterWithBounded() throws Exception {
        this.runCompositeFilter((PCollection<BeamRecord>)this.boundedInput1);
    }

    @Test
    public void testCompositeFilterWithUnbounded() throws Exception {
        this.runCompositeFilter((PCollection<BeamRecord>)this.unboundedInput1);
    }

    private void runCompositeFilter(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT * FROM TABLE_A WHERE f_int > 1 AND (f_long < 3000 OR f_string = 'string_row3')";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testCompositeFilter", (PTransform)BeamSql.queryMulti((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{(BeamRecord)recordsInTableA.get(1), (BeamRecord)recordsInTableA.get(2)});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testNoReturnFilterWithBounded() throws Exception {
        this.runNoReturnFilter((PCollection<BeamRecord>)this.boundedInput1);
    }

    @Test
    public void testNoReturnFilterWithUnbounded() throws Exception {
        this.runNoReturnFilter((PCollection<BeamRecord>)this.unboundedInput1);
    }

    private void runNoReturnFilter(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT * FROM TABLE_A WHERE f_int < 1";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testNoReturnFilter", (PTransform)BeamSql.queryMulti((String)sql));
        PAssert.that((PCollection)result).empty();
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFromInvalidTableName1() throws Exception {
        this.exceptions.expect(IllegalStateException.class);
        this.exceptions.expectMessage("Object 'TABLE_B' not found");
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT * FROM TABLE_B WHERE f_int < 1";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), (PCollection)this.boundedInput1).apply("testFromInvalidTableName1", (PTransform)BeamSql.queryMulti((String)sql));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFromInvalidTableName2() throws Exception {
        this.exceptions.expect(IllegalStateException.class);
        this.exceptions.expectMessage("Use fixed table name PCOLLECTION");
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT * FROM PCOLLECTION_NA";
        PCollection result = (PCollection)this.boundedInput1.apply((PTransform)BeamSql.query((String)sql));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testInvalidFilter() throws Exception {
        this.exceptions.expect(IllegalStateException.class);
        this.exceptions.expectMessage("Column 'f_int_na' not found in any table");
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT * FROM PCOLLECTION WHERE f_int_na = 0";
        PCollection result = (PCollection)this.boundedInput1.apply((PTransform)BeamSql.query((String)sql));
        this.pipeline.run().waitUntilFinish();
    }
}

