/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.integrationtest;

import java.util.Date;
import java.util.Iterator;
import org.apache.beam.sdk.extensions.sql.BeamSql;
import org.apache.beam.sdk.extensions.sql.integrationtest.BeamSqlBuiltinFunctionsIntegrationTestBase;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlDateFunctionsIntegrationTest
extends BeamSqlBuiltinFunctionsIntegrationTestBase {
    @Test
    public void testDateTimeFunctions() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("EXTRACT(YEAR FROM ts)", 1986L).addExpr("YEAR(ts)", 1986L).addExpr("QUARTER(ts)", 1L).addExpr("MONTH(ts)", 2L).addExpr("WEEK(ts)", 7L).addExpr("DAYOFMONTH(ts)", 15L).addExpr("DAYOFYEAR(ts)", 46L).addExpr("DAYOFWEEK(ts)", 7L).addExpr("HOUR(ts)", 11L).addExpr("MINUTE(ts)", 35L).addExpr("SECOND(ts)", 26L).addExpr("FLOOR(ts TO YEAR)", BeamSqlDateFunctionsIntegrationTest.parseDate("1986-01-01 00:00:00")).addExpr("CEIL(ts TO YEAR)", BeamSqlDateFunctionsIntegrationTest.parseDate("1987-01-01 00:00:00"));
        checker.buildRunAndCheck();
    }

    @Test
    public void testDateTimeFunctions_currentTime() throws Exception {
        String sql = "SELECT LOCALTIME as l,LOCALTIMESTAMP as l1,CURRENT_DATE as c1,CURRENT_TIME as c2,CURRENT_TIMESTAMP as c3 FROM PCOLLECTION";
        PCollection rows = (PCollection)this.getTestPCollection().apply((PTransform)BeamSql.query((String)sql));
        PAssert.that((PCollection)rows).satisfies((SerializableFunction)new Checker());
        this.pipeline.run();
    }

    private static class Checker
    implements SerializableFunction<Iterable<BeamRecord>, Void> {
        private Checker() {
        }

        public Void apply(Iterable<BeamRecord> input) {
            Iterator<BeamRecord> iter = input.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            BeamRecord row = iter.next();
            Date date = new Date();
            Assert.assertTrue((date.getTime() - row.getGregorianCalendar(0).getTime().getTime() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((date.getTime() - row.getDate(1).getTime() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((date.getTime() - row.getDate(2).getTime() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((date.getTime() - row.getGregorianCalendar(3).getTime().getTime() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((date.getTime() - row.getDate(4).getTime() < 1000L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)iter.hasNext());
            return null;
        }
    }
}

