/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.integrationtest;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.integrationtest.BeamSqlBuiltinFunctionsIntegrationTestBase;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Test;

public class BeamSqlComparisonOperatorsIntegrationTest
extends BeamSqlBuiltinFunctionsIntegrationTestBase {
    @Test
    public void testEquals() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_tinyint_1 = c_tinyint_1", true).addExpr("c_tinyint_1 = c_tinyint_2", false).addExpr("c_smallint_1 = c_smallint_1", true).addExpr("c_smallint_1 = c_smallint_2", false).addExpr("c_integer_1 = c_integer_1", true).addExpr("c_integer_1 = c_integer_2", false).addExpr("c_bigint_1 = c_bigint_1", true).addExpr("c_bigint_1 = c_bigint_2", false).addExpr("c_float_1 = c_float_1", true).addExpr("c_float_1 = c_float_2", false).addExpr("c_double_1 = c_double_1", true).addExpr("c_double_1 = c_double_2", false).addExpr("c_decimal_1 = c_decimal_1", true).addExpr("c_decimal_1 = c_decimal_2", false).addExpr("c_varchar_1 = c_varchar_1", true).addExpr("c_varchar_1 = c_varchar_2", false).addExpr("c_boolean_true = c_boolean_true", true).addExpr("c_boolean_true = c_boolean_false", false);
        checker.buildRunAndCheck();
    }

    @Test
    public void testNotEquals() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_tinyint_1 <> c_tinyint_1", false).addExpr("c_tinyint_1 <> c_tinyint_2", true).addExpr("c_smallint_1 <> c_smallint_1", false).addExpr("c_smallint_1 <> c_smallint_2", true).addExpr("c_integer_1 <> c_integer_1", false).addExpr("c_integer_1 <> c_integer_2", true).addExpr("c_bigint_1 <> c_bigint_1", false).addExpr("c_bigint_1 <> c_bigint_2", true).addExpr("c_float_1 <> c_float_1", false).addExpr("c_float_1 <> c_float_2", true).addExpr("c_double_1 <> c_double_1", false).addExpr("c_double_1 <> c_double_2", true).addExpr("c_decimal_1 <> c_decimal_1", false).addExpr("c_decimal_1 <> c_decimal_2", true).addExpr("c_varchar_1 <> c_varchar_1", false).addExpr("c_varchar_1 <> c_varchar_2", true).addExpr("c_boolean_true <> c_boolean_true", false).addExpr("c_boolean_true <> c_boolean_false", true);
        checker.buildRunAndCheck();
    }

    @Test
    public void testGreaterThan() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_tinyint_2 > c_tinyint_1", true).addExpr("c_tinyint_1 > c_tinyint_1", false).addExpr("c_tinyint_1 > c_tinyint_2", false).addExpr("c_smallint_2 > c_smallint_1", true).addExpr("c_smallint_1 > c_smallint_1", false).addExpr("c_smallint_1 > c_smallint_2", false).addExpr("c_integer_2 > c_integer_1", true).addExpr("c_integer_1 > c_integer_1", false).addExpr("c_integer_1 > c_integer_2", false).addExpr("c_bigint_2 > c_bigint_1", true).addExpr("c_bigint_1 > c_bigint_1", false).addExpr("c_bigint_1 > c_bigint_2", false).addExpr("c_float_2 > c_float_1", true).addExpr("c_float_1 > c_float_1", false).addExpr("c_float_1 > c_float_2", false).addExpr("c_double_2 > c_double_1", true).addExpr("c_double_1 > c_double_1", false).addExpr("c_double_1 > c_double_2", false).addExpr("c_decimal_2 > c_decimal_1", true).addExpr("c_decimal_1 > c_decimal_1", false).addExpr("c_decimal_1 > c_decimal_2", false).addExpr("c_varchar_2 > c_varchar_1", true).addExpr("c_varchar_1 > c_varchar_1", false).addExpr("c_varchar_1 > c_varchar_2", false);
        checker.buildRunAndCheck();
    }

    @Test(expected=RuntimeException.class)
    public void testGreaterThanException() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_boolean_false > c_boolean_true", false);
        checker.buildRunAndCheck();
    }

    @Test
    public void testGreaterThanOrEquals() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_tinyint_2 >= c_tinyint_1", true).addExpr("c_tinyint_1 >= c_tinyint_1", true).addExpr("c_tinyint_1 >= c_tinyint_2", false).addExpr("c_smallint_2 >= c_smallint_1", true).addExpr("c_smallint_1 >= c_smallint_1", true).addExpr("c_smallint_1 >= c_smallint_2", false).addExpr("c_integer_2 >= c_integer_1", true).addExpr("c_integer_1 >= c_integer_1", true).addExpr("c_integer_1 >= c_integer_2", false).addExpr("c_bigint_2 >= c_bigint_1", true).addExpr("c_bigint_1 >= c_bigint_1", true).addExpr("c_bigint_1 >= c_bigint_2", false).addExpr("c_float_2 >= c_float_1", true).addExpr("c_float_1 >= c_float_1", true).addExpr("c_float_1 >= c_float_2", false).addExpr("c_double_2 >= c_double_1", true).addExpr("c_double_1 >= c_double_1", true).addExpr("c_double_1 >= c_double_2", false).addExpr("c_decimal_2 >= c_decimal_1", true).addExpr("c_decimal_1 >= c_decimal_1", true).addExpr("c_decimal_1 >= c_decimal_2", false).addExpr("c_varchar_2 >= c_varchar_1", true).addExpr("c_varchar_1 >= c_varchar_1", true).addExpr("c_varchar_1 >= c_varchar_2", false);
        checker.buildRunAndCheck();
    }

    @Test(expected=RuntimeException.class)
    public void testGreaterThanOrEqualsException() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_boolean_false >= c_boolean_true", false);
        checker.buildRunAndCheck();
    }

    @Test
    public void testLessThan() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_tinyint_2 < c_tinyint_1", false).addExpr("c_tinyint_1 < c_tinyint_1", false).addExpr("c_tinyint_1 < c_tinyint_2", true).addExpr("c_smallint_2 < c_smallint_1", false).addExpr("c_smallint_1 < c_smallint_1", false).addExpr("c_smallint_1 < c_smallint_2", true).addExpr("c_integer_2 < c_integer_1", false).addExpr("c_integer_1 < c_integer_1", false).addExpr("c_integer_1 < c_integer_2", true).addExpr("c_bigint_2 < c_bigint_1", false).addExpr("c_bigint_1 < c_bigint_1", false).addExpr("c_bigint_1 < c_bigint_2", true).addExpr("c_float_2 < c_float_1", false).addExpr("c_float_1 < c_float_1", false).addExpr("c_float_1 < c_float_2", true).addExpr("c_double_2 < c_double_1", false).addExpr("c_double_1 < c_double_1", false).addExpr("c_double_1 < c_double_2", true).addExpr("c_decimal_2 < c_decimal_1", false).addExpr("c_decimal_1 < c_decimal_1", false).addExpr("c_decimal_1 < c_decimal_2", true).addExpr("c_varchar_2 < c_varchar_1", false).addExpr("c_varchar_1 < c_varchar_1", false).addExpr("c_varchar_1 < c_varchar_2", true);
        checker.buildRunAndCheck();
    }

    @Test(expected=RuntimeException.class)
    public void testLessThanException() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_boolean_false < c_boolean_true", false);
        checker.buildRunAndCheck();
    }

    @Test
    public void testLessThanOrEquals() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_tinyint_2 <= c_tinyint_1", false).addExpr("c_tinyint_1 <= c_tinyint_1", true).addExpr("c_tinyint_1 <= c_tinyint_2", true).addExpr("c_smallint_2 <= c_smallint_1", false).addExpr("c_smallint_1 <= c_smallint_1", true).addExpr("c_smallint_1 <= c_smallint_2", true).addExpr("c_integer_2 <= c_integer_1", false).addExpr("c_integer_1 <= c_integer_1", true).addExpr("c_integer_1 <= c_integer_2", true).addExpr("c_bigint_2 <= c_bigint_1", false).addExpr("c_bigint_1 <= c_bigint_1", true).addExpr("c_bigint_1 <= c_bigint_2", true).addExpr("c_float_2 <= c_float_1", false).addExpr("c_float_1 <= c_float_1", true).addExpr("c_float_1 <= c_float_2", true).addExpr("c_double_2 <= c_double_1", false).addExpr("c_double_1 <= c_double_1", true).addExpr("c_double_1 <= c_double_2", true).addExpr("c_decimal_2 <= c_decimal_1", false).addExpr("c_decimal_1 <= c_decimal_1", true).addExpr("c_decimal_1 <= c_decimal_2", true).addExpr("c_varchar_2 <= c_varchar_1", false).addExpr("c_varchar_1 <= c_varchar_1", true).addExpr("c_varchar_1 <= c_varchar_2", true);
        checker.buildRunAndCheck();
    }

    @Test(expected=RuntimeException.class)
    public void testLessThanOrEqualsException() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("c_boolean_false <= c_boolean_true", false);
        checker.buildRunAndCheck();
    }

    @Test
    public void testIsNullAndIsNotNull() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker().addExpr("1 IS NOT NULL", true).addExpr("NULL IS NOT NULL", false).addExpr("1 IS NULL", false).addExpr("NULL IS NULL", true);
        checker.buildRunAndCheck();
    }

    @Override
    protected PCollection<BeamRecord> getTestPCollection() {
        BeamRecordSqlType type = BeamRecordSqlType.create(Arrays.asList("c_tinyint_0", "c_tinyint_1", "c_tinyint_2", "c_smallint_0", "c_smallint_1", "c_smallint_2", "c_integer_0", "c_integer_1", "c_integer_2", "c_bigint_0", "c_bigint_1", "c_bigint_2", "c_float_0", "c_float_1", "c_float_2", "c_double_0", "c_double_1", "c_double_2", "c_decimal_0", "c_decimal_1", "c_decimal_2", "c_varchar_0", "c_varchar_1", "c_varchar_2", "c_boolean_false", "c_boolean_true"), Arrays.asList(-6, -6, -6, 5, 5, 5, 4, 4, 4, -5, -5, -5, 6, 6, 6, 8, 8, 8, 3, 3, 3, 12, 12, 12, 16, 16));
        try {
            return MockedBoundedTable.of(type).addRows((byte)0, (byte)1, (byte)2, (short)0, (short)1, (short)2, 0, 1, 2, 0L, 1L, 2L, Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), 0.0, 1.0, 2.0, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ONE.add(BigDecimal.ONE), "a", "b", "c", false, true).buildIOReader((Pipeline)this.pipeline).setCoder((Coder)type.getRecordCoder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

