/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema.transform;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.BeforeClass;

public class BeamTransformBaseTest {
    public static DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static BeamRecordSqlType inputRowType;
    public static List<BeamRecord> inputRows;

    @BeforeClass
    public static void prepareInput() throws NumberFormatException, ParseException {
        List<KV<String, SqlTypeName>> columnMetadata = Arrays.asList(KV.of((Object)"f_int", (Object)SqlTypeName.INTEGER), KV.of((Object)"f_long", (Object)SqlTypeName.BIGINT), KV.of((Object)"f_short", (Object)SqlTypeName.SMALLINT), KV.of((Object)"f_byte", (Object)SqlTypeName.TINYINT), KV.of((Object)"f_float", (Object)SqlTypeName.FLOAT), KV.of((Object)"f_double", (Object)SqlTypeName.DOUBLE), KV.of((Object)"f_string", (Object)SqlTypeName.VARCHAR), KV.of((Object)"f_timestamp", (Object)SqlTypeName.TIMESTAMP), KV.of((Object)"f_int2", (Object)SqlTypeName.INTEGER));
        inputRowType = BeamTransformBaseTest.initTypeOfSqlRow(columnMetadata);
        inputRows = Arrays.asList(BeamTransformBaseTest.initBeamSqlRow(columnMetadata, Arrays.asList(1, 1000L, Short.valueOf("1"), Byte.valueOf("1"), Float.valueOf(1.0f), 1.0, "string_row1", format.parse("2017-01-01 01:01:03"), 1)), BeamTransformBaseTest.initBeamSqlRow(columnMetadata, Arrays.asList(1, 2000L, Short.valueOf("2"), Byte.valueOf("2"), Float.valueOf(2.0f), 2.0, "string_row2", format.parse("2017-01-01 01:02:03"), 2)), BeamTransformBaseTest.initBeamSqlRow(columnMetadata, Arrays.asList(1, 3000L, Short.valueOf("3"), Byte.valueOf("3"), Float.valueOf(3.0f), 3.0, "string_row3", format.parse("2017-01-01 01:03:03"), 3)), BeamTransformBaseTest.initBeamSqlRow(columnMetadata, Arrays.asList(1, 4000L, Short.valueOf("4"), Byte.valueOf("4"), Float.valueOf(4.0f), 4.0, "string_row4", format.parse("2017-01-01 02:04:03"), 4)));
    }

    public static BeamRecordSqlType initTypeOfSqlRow(List<KV<String, SqlTypeName>> columnMetadata) {
        RelDataTypeFactory.FieldInfoBuilder builder = BeamQueryPlanner.TYPE_FACTORY.builder();
        for (KV<String, SqlTypeName> cm : columnMetadata) {
            builder.add((String)cm.getKey(), (SqlTypeName)cm.getValue());
        }
        return CalciteUtils.toBeamRowType((RelDataType)builder.build());
    }

    public static BeamRecord initBeamSqlRow(List<KV<String, SqlTypeName>> columnMetadata) {
        return BeamTransformBaseTest.initBeamSqlRow(columnMetadata, Arrays.asList(new Object[0]));
    }

    public static BeamRecord initBeamSqlRow(List<KV<String, SqlTypeName>> columnMetadata, List<Object> rowValues) {
        BeamRecordSqlType rowType = BeamTransformBaseTest.initTypeOfSqlRow(columnMetadata);
        return new BeamRecord((BeamRecordType)rowType, rowValues);
    }
}

