/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.schema.text.BeamTextCSVTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamTextCSVTableTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public TestPipeline pipeline2 = TestPipeline.create();
    private static Object[] data1 = new Object[]{1, 1L, Float.valueOf(1.1f), 1.1, "james"};
    private static Object[] data2 = new Object[]{2, 2L, Float.valueOf(2.2f), 2.2, "bond"};
    private static List<Object[]> testData = Arrays.asList(data1, data2);
    private static List<BeamRecord> testDataRows = new ArrayList<BeamRecord>(){
        {
            for (Object[] data : testData) {
                this.add(BeamTextCSVTableTest.buildRow(data));
            }
        }
    };
    private static Path tempFolder;
    private static File readerSourceFile;
    private static File writerTargetFile;

    @Test
    public void testBuildIOReader() {
        PCollection rows = new BeamTextCSVTable(BeamTextCSVTableTest.buildBeamSqlRowType(), readerSourceFile.getAbsolutePath()).buildIOReader((Pipeline)this.pipeline);
        PAssert.that((PCollection)rows).containsInAnyOrder(testDataRows);
        this.pipeline.run();
    }

    @Test
    public void testBuildIOWriter() {
        new BeamTextCSVTable(BeamTextCSVTableTest.buildBeamSqlRowType(), readerSourceFile.getAbsolutePath()).buildIOReader((Pipeline)this.pipeline).apply(new BeamTextCSVTable(BeamTextCSVTableTest.buildBeamSqlRowType(), writerTargetFile.getAbsolutePath()).buildIOWriter());
        this.pipeline.run();
        PCollection rows = new BeamTextCSVTable(BeamTextCSVTableTest.buildBeamSqlRowType(), writerTargetFile.getAbsolutePath()).buildIOReader((Pipeline)this.pipeline2);
        PAssert.that((PCollection)rows).containsInAnyOrder(testDataRows);
        this.pipeline2.run();
    }

    @BeforeClass
    public static void setUp() throws IOException {
        tempFolder = Files.createTempDirectory("BeamTextTableTest", new FileAttribute[0]);
        readerSourceFile = BeamTextCSVTableTest.writeToFile(testData, "readerSourceFile.txt");
        writerTargetFile = BeamTextCSVTableTest.writeToFile(testData, "writerTargetFile.txt");
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        Files.walkFileTree(tempFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static File writeToFile(List<Object[]> rows, String filename) throws IOException {
        File file = tempFolder.resolve(filename).toFile();
        FileOutputStream output = new FileOutputStream(file);
        BeamTextCSVTableTest.writeToStreamAndClose(rows, output);
        return file;
    }

    private static void writeToStreamAndClose(List<Object[]> rows, OutputStream outputStream) {
        try (PrintStream writer = new PrintStream(outputStream);){
            CSVPrinter printer = CSVFormat.DEFAULT.print((Appendable)writer);
            for (Object[] row : rows) {
                for (Object field : row) {
                    printer.print(field);
                }
                printer.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private RelProtoDataType buildRowType() {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory a0) {
                return a0.builder().add("id", SqlTypeName.INTEGER).add("order_id", SqlTypeName.BIGINT).add("price", SqlTypeName.FLOAT).add("amount", SqlTypeName.DOUBLE).add("user_name", SqlTypeName.VARCHAR).build();
            }
        };
    }

    private static RelDataType buildRelDataType() {
        return BeamQueryPlanner.TYPE_FACTORY.builder().add("id", SqlTypeName.INTEGER).add("order_id", SqlTypeName.BIGINT).add("price", SqlTypeName.FLOAT).add("amount", SqlTypeName.DOUBLE).add("user_name", SqlTypeName.VARCHAR).build();
    }

    private static BeamRecordSqlType buildBeamSqlRowType() {
        return CalciteUtils.toBeamRowType((RelDataType)BeamTextCSVTableTest.buildRelDataType());
    }

    private static BeamRecord buildRow(Object[] data) {
        return new BeamRecord((BeamRecordType)BeamTextCSVTableTest.buildBeamSqlRowType(), Arrays.asList(data));
    }
}

