/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema.kafka;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.schema.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.csv.CSVFormat;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamKafkaCSVTableTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    public static BeamRecord row1;
    public static BeamRecord row2;

    @BeforeClass
    public static void setUp() {
        row1 = new BeamRecord((BeamRecordType)BeamKafkaCSVTableTest.genRowType(), new Object[]{1L, 1, 1.0});
        row2 = new BeamRecord((BeamRecordType)BeamKafkaCSVTableTest.genRowType(), new Object[]{2L, 2, 2.0});
    }

    @Test
    public void testCsvRecorderDecoder() throws Exception {
        PCollection result = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"1,\"1\",1.0", (Object[])new String[]{"2,2,2.0"}))).apply((PTransform)ParDo.of((DoFn)new String2KvBytes()))).apply((PTransform)new BeamKafkaCSVTable.CsvRecorderDecoder(BeamKafkaCSVTableTest.genRowType(), CSVFormat.DEFAULT));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{row1, row2});
        this.pipeline.run();
    }

    @Test
    public void testCsvRecorderEncoder() throws Exception {
        PCollection result = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new BeamRecord[]{row2}))).apply((PTransform)new BeamKafkaCSVTable.CsvRecorderEncoder(BeamKafkaCSVTableTest.genRowType(), CSVFormat.DEFAULT))).apply((PTransform)new BeamKafkaCSVTable.CsvRecorderDecoder(BeamKafkaCSVTableTest.genRowType(), CSVFormat.DEFAULT));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{row1, row2});
        this.pipeline.run();
    }

    private static BeamRecordSqlType genRowType() {
        return CalciteUtils.toBeamRowType((RelDataType)new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory a0) {
                return a0.builder().add("order_id", SqlTypeName.BIGINT).add("site_id", SqlTypeName.INTEGER).add("price", SqlTypeName.DOUBLE).build();
            }
        }.apply((RelDataTypeFactory)BeamQueryPlanner.TYPE_FACTORY));
    }

    private static class String2KvBytes
    extends DoFn<String, KV<byte[], byte[]>>
    implements Serializable {
        private String2KvBytes() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            ctx.output((Object)KV.of((Object)new byte[0], (Object)((String)ctx.element()).getBytes()));
        }
    }
}

