/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Date;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BeamSortRelTest
extends BaseRelTest {
    static BeamSqlEnv sqlEnv = new BeamSqlEnv();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @Before
    public void prepare() {
        sqlEnv.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price", 93, "order_time").addRows(1L, 2, 1.0, new Date(0L), 1L, 1, 2.0, new Date(1L), 2L, 4, 3.0, new Date(2L), 2L, 1, 4.0, new Date(3L), 5L, 5, 5.0, new Date(4L), 6L, 6, 6.0, new Date(5L), 7L, 7, 7.0, new Date(6L), 8L, 8888, 8.0, new Date(7L), 8L, 999, 9.0, new Date(8L), 10L, 100, 10.0, new Date(9L)));
        sqlEnv.registerTable("SUB_ORDER_RAM", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price"));
    }

    @Test
    public void testOrderBy_basic() throws Exception {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc limit 4";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 2, 1.0, 1L, 1, 2.0, 2L, 4, 3.0, 2L, 1, 4.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_timestamp() throws Exception {
        String sql = "SELECT order_id, site_id, price, order_time FROM ORDER_DETAILS ORDER BY order_time desc limit 4";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price", 93, "order_time").addRows(7L, 7, 7.0, new Date(6L), 8L, 8888, 8.0, new Date(7L), 8L, 999, 9.0, new Date(8L), 10L, 100, 10.0, new Date(9L)).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_nullsFirst() throws Exception {
        sqlEnv.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 2, 1.0, 1L, null, 2.0, 2L, 1, 3.0, 2L, null, 4.0, 5L, 5, 5.0));
        sqlEnv.registerTable("SUB_ORDER_RAM", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price"));
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc NULLS FIRST limit 4";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, null, 2.0, 1L, 2, 1.0, 2L, null, 4.0, 2L, 1, 3.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_nullsLast() throws Exception {
        sqlEnv.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 2, 1.0, 1L, null, 2.0, 2L, 1, 3.0, 2L, null, 4.0, 5L, 5, 5.0));
        sqlEnv.registerTable("SUB_ORDER_RAM", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price"));
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc NULLS LAST limit 4";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 2, 1.0, 1L, null, 2.0, 2L, 1, 3.0, 2L, null, 4.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_with_offset() throws Exception {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc limit 4 offset 4";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(5L, 5, 5.0, 6L, 6, 6.0, 7L, 7, 7.0, 8L, 8888, 8.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_bigFetch() throws Exception {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc limit 11";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 2, 1.0, 1L, 1, 2.0, 2L, 4, 3.0, 2L, 1, 4.0, 5L, 5, 5.0, 6L, 6, 6.0, 7L, 7, 7.0, 8L, 8888, 8.0, 8L, 999, 9.0, 10L, 100, 10.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOrderBy_exception() throws Exception {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id)  SELECT  order_id, COUNT(*) FROM ORDER_DETAILS GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)ORDER BY order_id asc limit 11";
        TestPipeline pipeline = TestPipeline.create();
        this.compilePipeline(sql, (Pipeline)pipeline, sqlEnv);
    }
}

