/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Date;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamSetOperatorRelBaseTest
extends BaseRelTest {
    static BeamSqlEnv sqlEnv = new BeamSqlEnv();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    public static final Date THE_DATE = new Date(100000L);

    @BeforeClass
    public static void prepare() {
        sqlEnv.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price", 93, "order_time").addRows(1L, 1, 1.0, THE_DATE, 2L, 2, 2.0, THE_DATE));
    }

    @Test
    public void testSameWindow() throws Exception {
        String sql = "SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '1' HOUR)  UNION SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '1' HOUR) ";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", -5, "cnt").addRows(1L, 1, 1L, 2L, 2, 1L).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDifferentWindows() throws Exception {
        String sql = "SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '1' HOUR)  UNION SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '2' HOUR) ";
        Pipeline pipeline1 = Pipeline.create((PipelineOptions)PipelineOptionsFactory.create());
        this.compilePipeline(sql, pipeline1, sqlEnv);
        this.pipeline.run();
    }
}

