/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.CheckSize;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamMinusRelTest
extends BaseRelTest {
    static BeamSqlEnv sqlEnv = new BeamSqlEnv();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        sqlEnv.registerTable("ORDER_DETAILS1", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 1, 1.0, 1L, 1, 1.0, 2L, 2, 2.0, 4L, 4, 4.0, 4L, 4, 4.0));
        sqlEnv.registerTable("ORDER_DETAILS2", (BeamSqlTable)MockedBoundedTable.of(-5, "order_id", 4, "site_id", 8, "price").addRows(1L, 1, 1.0, 2L, 2, 2.0, 3L, 3, 3.0));
    }

    @Test
    public void testExcept() throws Exception {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(4L, 4, 4.0).getRows());
        this.pipeline.run();
    }

    @Test
    public void testExceptAll() throws Exception {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT ALL SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, sqlEnv);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(2));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(-5, "order_id", 4, "site_id", 8, "price").addRows(4L, 4, 4.0, 4L, 4, 4.0).getRows());
        this.pipeline.run();
    }
}

