/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Date;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSqlOutputToConsoleFn;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedUnboundedTable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamJoinRelUnboundedVsBoundedTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    private static final BeamSqlEnv BEAM_SQL_ENV = new BeamSqlEnv();
    public static final Date FIRST_DATE = new Date(1L);
    public static final Date SECOND_DATE = new Date(3600001L);
    public static final Date THIRD_DATE = new Date(7200002L);
    private static final Duration WINDOW_SIZE = Duration.standardHours((long)1L);

    @BeforeClass
    public static void prepare() {
        BEAM_SQL_ENV.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedUnboundedTable.of(4, "order_id", 4, "site_id", 4, "price", 93, "order_time").timestampColumnIndex(3).addRows(Duration.ZERO, 1, 1, 1, FIRST_DATE, 1, 2, 2, FIRST_DATE).addRows(WINDOW_SIZE.plus((ReadableDuration)Duration.standardSeconds((long)1L)), 2, 2, 3, SECOND_DATE, 2, 3, 3, SECOND_DATE, 1, 2, 3, FIRST_DATE).addRows(WINDOW_SIZE.plus((ReadableDuration)WINDOW_SIZE).plus((ReadableDuration)Duration.standardSeconds((long)1L)), 3, 3, 3, THIRD_DATE, 2, 2, 3, SECOND_DATE));
        BEAM_SQL_ENV.registerTable("ORDER_DETAILS1", (BeamSqlTable)MockedBoundedTable.of(4, "order_id", 12, "buyer").addRows(1, "james", 2, "bond"));
    }

    @Test
    public void testInnerJoin_unboundedTableOnTheLeftSide() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  JOIN  ORDER_DETAILS1 o2  on  o1.order_id=o2.order_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "sum_site_id", 12, "buyer").addRows(1, 3, "james", 2, 5, "bond").getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testInnerJoin_boundedTableOnTheLeftSide() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "sum_site_id", 12, "buyer").addRows(1, 3, "james", 2, 5, "bond").getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testLeftOuterJoin() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  LEFT OUTER JOIN  ORDER_DETAILS1 o2  on  o1.order_id=o2.order_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        rows.apply((PTransform)ParDo.of((DoFn)new BeamSqlOutputToConsoleFn("helloworld")));
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "sum_site_id", 12, "buyer").addRows(1, 3, "james", 2, 5, "bond", 3, 3, null).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLeftOuterJoinError() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  LEFT OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        this.pipeline.run();
    }

    @Test
    public void testRightOuterJoin() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  RIGHT OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "sum_site_id", 12, "buyer").addRows(1, 3, "james", 2, 5, "bond", 3, 3, null).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRightOuterJoinError() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  RIGHT OUTER JOIN  ORDER_DETAILS1 o2  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFullOuterJoinError() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  FULL OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        this.pipeline.run();
    }
}

