/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamJoinRelBoundedVsBoundedTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    private static final BeamSqlEnv BEAM_SQL_ENV = new BeamSqlEnv();
    public static final MockedBoundedTable ORDER_DETAILS1 = MockedBoundedTable.of(4, "order_id", 4, "site_id", 4, "price").addRows(1, 2, 3, 2, 3, 3, 3, 4, 5);
    public static final MockedBoundedTable ORDER_DETAILS2 = MockedBoundedTable.of(4, "order_id", 4, "site_id", 4, "price").addRows(1, 2, 3, 2, 3, 3, 3, 4, 5);

    @BeforeClass
    public static void prepare() {
        BEAM_SQL_ENV.registerTable("ORDER_DETAILS1", (BeamSqlTable)ORDER_DETAILS1);
        BEAM_SQL_ENV.registerTable("ORDER_DETAILS2", (BeamSqlTable)ORDER_DETAILS2);
    }

    @Test
    public void testInnerJoin() throws Exception {
        String sql = "SELECT *  FROM ORDER_DETAILS1 o1 JOIN ORDER_DETAILS2 o2 on  o1.order_id=o2.site_id AND o2.price=o1.site_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "site_id", 4, "price", 4, "order_id0", 4, "site_id0", 4, "price0").addRows(2, 3, 3, 1, 2, 3).getRows());
        this.pipeline.run();
    }

    @Test
    public void testLeftOuterJoin() throws Exception {
        String sql = "SELECT *  FROM ORDER_DETAILS1 o1 LEFT OUTER JOIN ORDER_DETAILS2 o2 on  o1.order_id=o2.site_id AND o2.price=o1.site_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        this.pipeline.enableAbandonedNodeEnforcement(false);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "site_id", 4, "price", 4, "order_id0", 4, "site_id0", 4, "price0").addRows(1, 2, 3, null, null, null, 2, 3, 3, 1, 2, 3, 3, 4, 5, null, null, null).getRows());
        this.pipeline.run();
    }

    @Test
    public void testRightOuterJoin() throws Exception {
        String sql = "SELECT *  FROM ORDER_DETAILS1 o1 RIGHT OUTER JOIN ORDER_DETAILS2 o2 on  o1.order_id=o2.site_id AND o2.price=o1.site_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "site_id", 4, "price", 4, "order_id0", 4, "site_id0", 4, "price0").addRows(2, 3, 3, 1, 2, 3, null, null, null, 2, 3, 3, null, null, null, 3, 4, 5).getRows());
        this.pipeline.run();
    }

    @Test
    public void testFullOuterJoin() throws Exception {
        String sql = "SELECT *  FROM ORDER_DETAILS1 o1 FULL OUTER JOIN ORDER_DETAILS2 o2 on  o1.order_id=o2.site_id AND o2.price=o1.site_id";
        PCollection<BeamRecord> rows = this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(4, "order_id", 4, "site_id", 4, "price", 4, "order_id0", 4, "site_id0", 4, "price0").addRows(2, 3, 3, 1, 2, 3, 1, 2, 3, null, null, null, 3, 4, 5, null, null, null, null, null, null, 2, 3, 3, null, null, null, 3, 4, 5).getRows());
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testException_nonEqualJoin() throws Exception {
        String sql = "SELECT *  FROM ORDER_DETAILS1 o1 JOIN ORDER_DETAILS2 o2 on  o1.order_id>o2.site_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testException_crossJoin() throws Exception {
        String sql = "SELECT *  FROM ORDER_DETAILS1 o1, ORDER_DETAILS2 o2";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.compilePipeline(sql, (Pipeline)this.pipeline, BEAM_SQL_ENV);
        this.pipeline.run();
    }
}

