/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.ArrayList;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlTrimExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlTrimExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void accept() throws Exception {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)" hello "));
        Assert.assertTrue((boolean)new BeamSqlTrimExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SYMBOL, (Object)SqlTrimFunction.Flag.BOTH));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"he"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hehe__hehe"));
        Assert.assertTrue((boolean)new BeamSqlTrimExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"he"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hehe__hehe"));
        Assert.assertFalse((boolean)new BeamSqlTrimExpression(operands).accept());
    }

    @Test
    public void evaluate() throws Exception {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SYMBOL, (Object)SqlTrimFunction.Flag.LEADING));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"he"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hehe__hehe"));
        Assert.assertEquals((Object)"__hehe", (Object)new BeamSqlTrimExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SYMBOL, (Object)SqlTrimFunction.Flag.TRAILING));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"he"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hehe__hehe"));
        Assert.assertEquals((Object)"hehe__", (Object)new BeamSqlTrimExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SYMBOL, (Object)SqlTrimFunction.Flag.BOTH));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"he"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"__"));
        Assert.assertEquals((Object)"__", (Object)new BeamSqlTrimExpression(operands).evaluate(record, null).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)" hello "));
        Assert.assertEquals((Object)"hello", (Object)new BeamSqlTrimExpression(operands).evaluate(record, null).getValue());
    }

    @Test
    public void leadingTrim() throws Exception {
        Assert.assertEquals((Object)"__hehe", (Object)BeamSqlTrimExpression.leadingTrim((String)"hehe__hehe", (String)"he"));
    }

    @Test
    public void trailingTrim() throws Exception {
        Assert.assertEquals((Object)"hehe__", (Object)BeamSqlTrimExpression.trailingTrim((String)"hehe__hehe", (String)"he"));
    }

    @Test
    public void trim() throws Exception {
        Assert.assertEquals((Object)"__", (Object)BeamSqlTrimExpression.leadingTrim((String)BeamSqlTrimExpression.trailingTrim((String)"hehe__hehe", (String)"he"), (String)"he"));
    }
}

