/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlInputRefExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlEqualsExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlGreaterThanExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlGreaterThanOrEqualsExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlLessThanExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlLessThanOrEqualsExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlNotEqualsExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlCompareExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testEqual() {
        BeamSqlEqualsExpression exp1 = new BeamSqlEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)100L)));
        Assert.assertEquals((Object)false, (Object)exp1.evaluate(record, null).getValue());
        BeamSqlEqualsExpression exp2 = new BeamSqlEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1234567L)));
        Assert.assertEquals((Object)true, (Object)exp2.evaluate(record, null).getValue());
    }

    @Test
    public void testLargerThan() {
        BeamSqlGreaterThanExpression exp1 = new BeamSqlGreaterThanExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1234567L)));
        Assert.assertEquals((Object)false, (Object)exp1.evaluate(record, null).getValue());
        BeamSqlGreaterThanExpression exp2 = new BeamSqlGreaterThanExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1234566L)));
        Assert.assertEquals((Object)true, (Object)exp2.evaluate(record, null).getValue());
    }

    @Test
    public void testLargerThanEqual() {
        BeamSqlGreaterThanOrEqualsExpression exp1 = new BeamSqlGreaterThanOrEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1234567L)));
        Assert.assertEquals((Object)true, (Object)exp1.evaluate(record, null).getValue());
        BeamSqlGreaterThanOrEqualsExpression exp2 = new BeamSqlGreaterThanOrEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1234568L)));
        Assert.assertEquals((Object)false, (Object)exp2.evaluate(record, null).getValue());
    }

    @Test
    public void testLessThan() {
        BeamSqlLessThanExpression exp1 = new BeamSqlLessThanExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.INTEGER, 1), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1)));
        Assert.assertEquals((Object)true, (Object)exp1.evaluate(record, null).getValue());
        BeamSqlLessThanExpression exp2 = new BeamSqlLessThanExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.INTEGER, 1), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)-1)));
        Assert.assertEquals((Object)false, (Object)exp2.evaluate(record, null).getValue());
    }

    @Test
    public void testLessThanEqual() {
        BeamSqlLessThanOrEqualsExpression exp1 = new BeamSqlLessThanOrEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.DOUBLE, 2), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)8.9)));
        Assert.assertEquals((Object)true, (Object)exp1.evaluate(record, null).getValue());
        BeamSqlLessThanOrEqualsExpression exp2 = new BeamSqlLessThanOrEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.DOUBLE, 2), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)8.0)));
        Assert.assertEquals((Object)false, (Object)exp2.evaluate(record, null).getValue());
    }

    @Test
    public void testNotEqual() {
        BeamSqlNotEqualsExpression exp1 = new BeamSqlNotEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 3), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1234567L)));
        Assert.assertEquals((Object)false, (Object)exp1.evaluate(record, null).getValue());
        BeamSqlNotEqualsExpression exp2 = new BeamSqlNotEqualsExpression(Arrays.asList(new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 3), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)0L)));
        Assert.assertEquals((Object)true, (Object)exp2.evaluate(record, null).getValue());
    }
}

