/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutor;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlCaseExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlInputRefExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlDivideExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlMinusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlModExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlMultiplyExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlPlusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlEqualsExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison.BeamSqlLessThanOrEqualsExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlCurrentDateExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlCurrentTimeExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlCurrentTimestampExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDateCeilExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDateFloorExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlExtractExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.logical.BeamSqlAndExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.logical.BeamSqlNotExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.logical.BeamSqlOrExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlCharLengthExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlConcatExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlInitCapExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlLowerExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlOverlayExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlPositionExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlSubstringExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlTrimExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlUpperExpression;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamFilterRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamProjectRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlFnExecutorTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testBeamFilterRel() {
        RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, Arrays.asList(rexBuilder.makeInputRef(relDataType, 0), rexBuilder.makeBigintLiteral(new BigDecimal(1000L)))), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, Arrays.asList(rexBuilder.makeInputRef(relDataType, 1), rexBuilder.makeExactLiteral(new BigDecimal(0))))));
        BeamFilterRel beamFilterRel = new BeamFilterRel(cluster, RelTraitSet.createEmpty(), null, condition);
        BeamSqlFnExecutor executor = new BeamSqlFnExecutor((BeamRelNode)beamFilterRel);
        executor.prepare();
        Assert.assertEquals((long)1L, (long)executor.exps.size());
        BeamSqlExpression l1Exp = (BeamSqlExpression)executor.exps.get(0);
        Assert.assertTrue((boolean)(l1Exp instanceof BeamSqlAndExpression));
        Assert.assertEquals((Object)SqlTypeName.BOOLEAN, (Object)l1Exp.getOutputType());
        Assert.assertEquals((long)2L, (long)l1Exp.getOperands().size());
        BeamSqlExpression l1Left = (BeamSqlExpression)l1Exp.getOperands().get(0);
        BeamSqlExpression l1Right = (BeamSqlExpression)l1Exp.getOperands().get(1);
        Assert.assertTrue((boolean)(l1Left instanceof BeamSqlLessThanOrEqualsExpression));
        Assert.assertTrue((boolean)(l1Right instanceof BeamSqlEqualsExpression));
        Assert.assertEquals((long)2L, (long)l1Left.getOperands().size());
        BeamSqlExpression l1LeftLeft = (BeamSqlExpression)l1Left.getOperands().get(0);
        BeamSqlExpression l1LeftRight = (BeamSqlExpression)l1Left.getOperands().get(1);
        Assert.assertTrue((boolean)(l1LeftLeft instanceof BeamSqlInputRefExpression));
        Assert.assertTrue((boolean)(l1LeftRight instanceof BeamSqlPrimitive));
        Assert.assertEquals((long)2L, (long)l1Right.getOperands().size());
        BeamSqlExpression l1RightLeft = (BeamSqlExpression)l1Right.getOperands().get(0);
        BeamSqlExpression l1RightRight = (BeamSqlExpression)l1Right.getOperands().get(1);
        Assert.assertTrue((boolean)(l1RightLeft instanceof BeamSqlInputRefExpression));
        Assert.assertTrue((boolean)(l1RightRight instanceof BeamSqlPrimitive));
    }

    @Test
    public void testBeamProjectRel() {
        BeamProjectRel relNode = new BeamProjectRel(cluster, RelTraitSet.createEmpty(), relBuilder.values(relDataType, new Object[]{1234567L, 0, 8.9, null}).build(), rexBuilder.identityProjects(relDataType), relDataType);
        BeamSqlFnExecutor executor = new BeamSqlFnExecutor((BeamRelNode)relNode);
        executor.prepare();
        Assert.assertEquals((long)4L, (long)executor.exps.size());
        Assert.assertTrue((boolean)(executor.exps.get(0) instanceof BeamSqlInputRefExpression));
        Assert.assertTrue((boolean)(executor.exps.get(1) instanceof BeamSqlInputRefExpression));
        Assert.assertTrue((boolean)(executor.exps.get(2) instanceof BeamSqlInputRefExpression));
        Assert.assertTrue((boolean)(executor.exps.get(3) instanceof BeamSqlInputRefExpression));
    }

    @Test
    public void testBuildExpression_logical() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral(false)));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlAndExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral(false)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlOrExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, Arrays.asList(rexBuilder.makeLiteral(true)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlNotExpression));
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildExpression_logical_andOr_invalidOperand() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral("hello")));
        BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildExpression_logical_not_invalidOperand() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, Arrays.asList(rexBuilder.makeLiteral("hello")));
        BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildExpression_logical_not_invalidOperandCount() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral(true)));
        BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
    }

    @Test
    public void testBuildExpression_arithmetic() {
        this.testBuildArithmeticExpression((SqlOperator)SqlStdOperatorTable.PLUS, BeamSqlPlusExpression.class);
        this.testBuildArithmeticExpression((SqlOperator)SqlStdOperatorTable.MINUS, BeamSqlMinusExpression.class);
        this.testBuildArithmeticExpression((SqlOperator)SqlStdOperatorTable.MULTIPLY, BeamSqlMultiplyExpression.class);
        this.testBuildArithmeticExpression((SqlOperator)SqlStdOperatorTable.DIVIDE, BeamSqlDivideExpression.class);
        this.testBuildArithmeticExpression((SqlOperator)SqlStdOperatorTable.MOD, BeamSqlModExpression.class);
    }

    private void testBuildArithmeticExpression(SqlOperator fn, Class<? extends BeamSqlExpression> clazz) {
        RexNode rexNode = rexBuilder.makeCall(fn, Arrays.asList(rexBuilder.makeBigintLiteral(new BigDecimal(1L)), rexBuilder.makeBigintLiteral(new BigDecimal(1L))));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)exp.getClass().equals(clazz));
    }

    @Test
    public void testBuildExpression_string() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, Arrays.asList(rexBuilder.makeLiteral("hello "), rexBuilder.makeLiteral("world")));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlConcatExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.POSITION, Arrays.asList(rexBuilder.makeLiteral("hello"), rexBuilder.makeLiteral("worldhello")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlPositionExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.POSITION, Arrays.asList(rexBuilder.makeLiteral("hello"), rexBuilder.makeLiteral("worldhello"), rexBuilder.makeCast(BeamQueryPlanner.TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER), (RexNode)rexBuilder.makeBigintLiteral(BigDecimal.ONE))));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlPositionExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, Arrays.asList(rexBuilder.makeLiteral("hello")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCharLengthExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.UPPER, Arrays.asList(rexBuilder.makeLiteral("hello")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlUpperExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LOWER, Arrays.asList(rexBuilder.makeLiteral("HELLO")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlLowerExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.INITCAP, Arrays.asList(rexBuilder.makeLiteral("hello")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlInitCapExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, Arrays.asList(rexBuilder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), rexBuilder.makeLiteral("HELLO"), rexBuilder.makeLiteral("HELLO")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlTrimExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, Arrays.asList(rexBuilder.makeLiteral("HELLO"), rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlSubstringExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, Arrays.asList(rexBuilder.makeLiteral("HELLO"), rexBuilder.makeBigintLiteral(BigDecimal.ZERO), rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlSubstringExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OVERLAY, Arrays.asList(rexBuilder.makeLiteral("HELLO"), rexBuilder.makeLiteral("HELLO"), rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlOverlayExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OVERLAY, Arrays.asList(rexBuilder.makeLiteral("HELLO"), rexBuilder.makeLiteral("HELLO"), rexBuilder.makeBigintLiteral(BigDecimal.ZERO), rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlOverlayExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral("HELLO"), rexBuilder.makeLiteral("HELLO")));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCaseExpression));
    }

    @Test
    public void testBuildExpression_date() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date());
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, Arrays.asList(rexBuilder.makeDateLiteral(calendar), rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH)));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlDateCeilExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.FLOOR, Arrays.asList(rexBuilder.makeDateLiteral(calendar), rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlDateFloorExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EXTRACT, Arrays.asList(rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), rexBuilder.makeDateLiteral(calendar)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlExtractExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, Arrays.asList(new RexNode[0]));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCurrentDateExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LOCALTIME, Arrays.asList(new RexNode[0]));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCurrentTimeExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, Arrays.asList(new RexNode[0]));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCurrentTimestampExpression));
    }
}

