/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;

public class TestUtils {
    public static List<String> beamSqlRows2Strings(List<BeamRecord> rows) {
        ArrayList<String> strs = new ArrayList<String>();
        for (BeamRecord row : rows) {
            strs.add(row.toString());
        }
        return strs;
    }

    public static BeamRecordSqlType buildBeamSqlRowType(Object ... args) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; i += 2) {
            types.add((Integer)args[i]);
            names.add((String)args[i + 1]);
        }
        return BeamRecordSqlType.create(names, types);
    }

    public static List<BeamRecord> buildRows(BeamRecordSqlType type, List args) {
        ArrayList<BeamRecord> rows = new ArrayList<BeamRecord>();
        int fieldCount = type.getFieldCount();
        for (int i = 0; i < args.size(); i += fieldCount) {
            rows.add(new BeamRecord((BeamRecordType)type, args.subList(i, i + fieldCount)));
        }
        return rows;
    }

    public static class RowsBuilder {
        private BeamRecordSqlType type;
        private List<BeamRecord> rows = new ArrayList<BeamRecord>();

        public static RowsBuilder of(Object ... args) {
            BeamRecordSqlType beamSQLRowType = TestUtils.buildBeamSqlRowType(args);
            RowsBuilder builder = new RowsBuilder();
            builder.type = beamSQLRowType;
            return builder;
        }

        public static RowsBuilder of(BeamRecordSqlType beamSQLRowType) {
            RowsBuilder builder = new RowsBuilder();
            builder.type = beamSQLRowType;
            return builder;
        }

        public RowsBuilder addRows(Object ... args) {
            this.rows.addAll(TestUtils.buildRows(this.type, Arrays.asList(args)));
            return this;
        }

        public RowsBuilder addRows(List args) {
            this.rows.addAll(TestUtils.buildRows(this.type, args));
            return this;
        }

        public List<BeamRecord> getRows() {
            return this.rows;
        }

        public List<String> getStringRows() {
            return TestUtils.beamSqlRows2Strings(this.rows);
        }
    }

    public static class BeamSqlRow2StringDoFn
    extends DoFn<BeamRecord, String> {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            ctx.output((Object)((BeamRecord)ctx.element()).toString());
        }
    }
}

