/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.BeamSql;
import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.junit.Test;

public class BeamSqlDslProjectTest
extends BeamSqlDslBase {
    @Test
    public void testSelectAllWithBounded() throws Exception {
        this.runSelectAll((PCollection<BeamRecord>)this.boundedInput2);
    }

    @Test
    public void testSelectAllWithUnbounded() throws Exception {
        this.runSelectAll((PCollection<BeamRecord>)this.unboundedInput2);
    }

    private void runSelectAll(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT * FROM PCOLLECTION";
        PCollection result = (PCollection)input.apply("testSelectAll", (PTransform)BeamSql.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{(BeamRecord)recordsInTableA.get(0)});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testPartialFieldsWithBounded() throws Exception {
        this.runPartialFields((PCollection<BeamRecord>)this.boundedInput2);
    }

    @Test
    public void testPartialFieldsWithUnbounded() throws Exception {
        this.runPartialFields((PCollection<BeamRecord>)this.unboundedInput2);
    }

    private void runPartialFields(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT f_int, f_long FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testPartialFields", (PTransform)BeamSql.queryMulti((String)sql));
        BeamRecordSqlType resultType = BeamRecordSqlType.create(Arrays.asList("f_int", "f_long"), Arrays.asList(4, -5));
        BeamRecord record = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(0)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(0)).getFieldValue(1)});
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{record});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testPartialFieldsInMultipleRowWithBounded() throws Exception {
        this.runPartialFieldsInMultipleRow((PCollection<BeamRecord>)this.boundedInput1);
    }

    @Test
    public void testPartialFieldsInMultipleRowWithUnbounded() throws Exception {
        this.runPartialFieldsInMultipleRow((PCollection<BeamRecord>)this.unboundedInput1);
    }

    private void runPartialFieldsInMultipleRow(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT f_int, f_long FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testPartialFieldsInMultipleRow", (PTransform)BeamSql.queryMulti((String)sql));
        BeamRecordSqlType resultType = BeamRecordSqlType.create(Arrays.asList("f_int", "f_long"), Arrays.asList(4, -5));
        BeamRecord record1 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(0)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(0)).getFieldValue(1)});
        BeamRecord record2 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(1)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(1)).getFieldValue(1)});
        BeamRecord record3 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(2)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(2)).getFieldValue(1)});
        BeamRecord record4 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(3)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(3)).getFieldValue(1)});
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{record1, record2, record3, record4});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testPartialFieldsInRowsWithBounded() throws Exception {
        this.runPartialFieldsInRows((PCollection<BeamRecord>)this.boundedInput1);
    }

    @Test
    public void testPartialFieldsInRowsWithUnbounded() throws Exception {
        this.runPartialFieldsInRows((PCollection<BeamRecord>)this.unboundedInput1);
    }

    private void runPartialFieldsInRows(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT f_int, f_long FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testPartialFieldsInRows", (PTransform)BeamSql.queryMulti((String)sql));
        BeamRecordSqlType resultType = BeamRecordSqlType.create(Arrays.asList("f_int", "f_long"), Arrays.asList(4, -5));
        BeamRecord record1 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(0)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(0)).getFieldValue(1)});
        BeamRecord record2 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(1)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(1)).getFieldValue(1)});
        BeamRecord record3 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(2)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(2)).getFieldValue(1)});
        BeamRecord record4 = new BeamRecord((BeamRecordType)resultType, new Object[]{((BeamRecord)recordsInTableA.get(3)).getFieldValue(0), ((BeamRecord)recordsInTableA.get(3)).getFieldValue(1)});
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{record1, record2, record3, record4});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testLiteralFieldWithBounded() throws Exception {
        this.runLiteralField((PCollection<BeamRecord>)this.boundedInput2);
    }

    @Test
    public void testLiteralFieldWithUnbounded() throws Exception {
        this.runLiteralField((PCollection<BeamRecord>)this.unboundedInput2);
    }

    public void runLiteralField(PCollection<BeamRecord> input) throws Exception {
        String sql = "SELECT 1 as literal_field FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), input).apply("testLiteralField", (PTransform)BeamSql.queryMulti((String)sql));
        BeamRecordSqlType resultType = BeamRecordSqlType.create(Arrays.asList("literal_field"), Arrays.asList(4));
        BeamRecord record = new BeamRecord((BeamRecordType)resultType, new Object[]{1});
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new BeamRecord[]{record});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testProjectUnknownField() throws Exception {
        this.exceptions.expect(IllegalStateException.class);
        this.exceptions.expectMessage("Column 'f_int_na' not found in any table");
        this.pipeline.enableAbandonedNodeEnforcement(false);
        String sql = "SELECT f_int_na FROM TABLE_A";
        PCollection result = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("TABLE_A"), (PCollection)this.boundedInput1).apply("testProjectUnknownField", (PTransform)BeamSql.queryMulti((String)sql));
        this.pipeline.run().waitUntilFinish();
    }
}

