/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public class BeamSqlDslBase {
    public static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();
    public static BeamRecordSqlType rowTypeInTableA;
    public static List<BeamRecord> recordsInTableA;
    public PCollection<BeamRecord> boundedInput1;
    public PCollection<BeamRecord> boundedInput2;
    public PCollection<BeamRecord> unboundedInput1;
    public PCollection<BeamRecord> unboundedInput2;

    @BeforeClass
    public static void prepareClass() throws ParseException {
        rowTypeInTableA = BeamRecordSqlType.create(Arrays.asList("f_int", "f_long", "f_short", "f_byte", "f_float", "f_double", "f_string", "f_timestamp", "f_int2", "f_decimal"), Arrays.asList(4, -5, 5, -6, 6, 8, 12, 93, 4, 3));
        recordsInTableA = BeamSqlDslBase.prepareInputRowsInTableA();
    }

    @Before
    public void preparePCollections() {
        this.boundedInput1 = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("boundedInput1", (PTransform)Create.of(recordsInTableA).withCoder((Coder)rowTypeInTableA.getRecordCoder()));
        this.boundedInput2 = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("boundedInput2", (PTransform)Create.of((Object)recordsInTableA.get(0), (Object[])new BeamRecord[0]).withCoder((Coder)rowTypeInTableA.getRecordCoder()));
        this.unboundedInput1 = this.prepareUnboundedPCollection1();
        this.unboundedInput2 = this.prepareUnboundedPCollection2();
    }

    private PCollection<BeamRecord> prepareUnboundedPCollection1() {
        TestStream.Builder values = TestStream.create((Coder)rowTypeInTableA.getRecordCoder());
        for (BeamRecord row : recordsInTableA) {
            values = values.advanceWatermarkTo(new Instant((Object)row.getDate("f_timestamp")));
            values = values.addElements((Object)row, (Object[])new BeamRecord[0]);
        }
        return (PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedInput1", (PTransform)values.advanceWatermarkToInfinity());
    }

    private PCollection<BeamRecord> prepareUnboundedPCollection2() {
        TestStream.Builder values = TestStream.create((Coder)rowTypeInTableA.getRecordCoder());
        BeamRecord row = recordsInTableA.get(0);
        values = values.advanceWatermarkTo(new Instant((Object)row.getDate("f_timestamp")));
        values = values.addElements((Object)row, (Object[])new BeamRecord[0]);
        return (PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedInput2", (PTransform)values.advanceWatermarkToInfinity());
    }

    private static List<BeamRecord> prepareInputRowsInTableA() throws ParseException {
        ArrayList<BeamRecord> rows = new ArrayList<BeamRecord>();
        BeamRecord row1 = new BeamRecord((BeamRecordType)rowTypeInTableA, new Object[]{1, 1000L, Short.valueOf("1"), Byte.valueOf("1"), Float.valueOf(1.0f), 1.0, "string_row1", FORMAT.parse("2017-01-01 01:01:03"), 0, new BigDecimal(1)});
        rows.add(row1);
        BeamRecord row2 = new BeamRecord((BeamRecordType)rowTypeInTableA, new Object[]{2, 2000L, Short.valueOf("2"), Byte.valueOf("2"), Float.valueOf(2.0f), 2.0, "string_row2", FORMAT.parse("2017-01-01 01:02:03"), 0, new BigDecimal(2)});
        rows.add(row2);
        BeamRecord row3 = new BeamRecord((BeamRecordType)rowTypeInTableA, new Object[]{3, 3000L, Short.valueOf("3"), Byte.valueOf("3"), Float.valueOf(3.0f), 3.0, "string_row3", FORMAT.parse("2017-01-01 01:06:03"), 0, new BigDecimal(3)});
        rows.add(row3);
        BeamRecord row4 = new BeamRecord((BeamRecordType)rowTypeInTableA, new Object[]{4, 4000L, Short.valueOf("4"), Byte.valueOf("4"), Float.valueOf(4.0f), 4.0, "string_row4", FORMAT.parse("2017-01-01 02:04:03"), 0, new BigDecimal(4)});
        rows.add(row4);
        return rows;
    }
}

