/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;

/**
 * '/' operator.
 */
public class BeamSqlDivideExpression extends BeamSqlArithmeticExpression {
  public BeamSqlDivideExpression(List<BeamSqlExpression> operands) {
    super(operands);
  }

  @Override protected BigDecimal calc(BigDecimal left, BigDecimal right) {
    return left.divide(right, 10, RoundingMode.HALF_EVEN);
  }
}
