/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Test;

public class BigQueryTableProviderTest {
    private BigQueryTableProvider provider = new BigQueryTableProvider();

    @Test
    public void testGetTableType() throws Exception {
        Assert.assertEquals((Object)"bigquery", (Object)this.provider.getTableType());
    }

    @Test
    public void testBuildBeamSqlTable() throws Exception {
        Table table = BigQueryTableProviderTest.fakeTable("hello");
        BeamSqlTable sqlTable = this.provider.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)sqlTable);
        Assert.assertTrue((boolean)(sqlTable instanceof BigQueryTable));
        BigQueryTable bqTable = (BigQueryTable)sqlTable;
        Assert.assertEquals((Object)"project:dataset.table", (Object)bqTable.bqLocation);
    }

    private static Table fakeTable(String name) {
        return Table.builder().name(name).comment(name + " table").location("project:dataset.table").schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type("bigquery").build();
    }
}

