/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.integrationtest;

import java.util.Iterator;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.integrationtest.BeamSqlBuiltinFunctionsIntegrationTestBase;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlDateFunctionsIntegrationTest
extends BeamSqlBuiltinFunctionsIntegrationTestBase {
    @Test
    public void testDateTimeFunctions_currentTime() throws Exception {
        String sql = "SELECT LOCALTIME as l,LOCALTIMESTAMP as l1,CURRENT_DATE as c1,CURRENT_TIME as c2,CURRENT_TIMESTAMP as c3 FROM PCOLLECTION";
        PCollection rows = (PCollection)this.getTestPCollection().apply((PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)rows).satisfies((SerializableFunction)new Checker());
        this.pipeline.run();
    }

    private static class Checker
    implements SerializableFunction<Iterable<Row>, Void> {
        private Checker() {
        }

        public Void apply(Iterable<Row> input) {
            Iterator<Row> iter = input.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Row row = iter.next();
            DateTime date = DateTime.now();
            long millis = date.getMillis();
            int timeMillis = (int)(date.getMillis() % 86400000L);
            Assert.assertTrue(((long)timeMillis - row.getDateTime(0).getMillis() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue(((long)timeMillis - row.getDateTime(0).getMillis() > -1000L ? 1 : 0) != 0);
            Assert.assertTrue((millis - row.getDateTime(1).getMillis() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((millis - row.getDateTime(1).getMillis() > -1000L ? 1 : 0) != 0);
            Assert.assertTrue((millis - row.getDateTime(2).getMillis() < 86400000L ? 1 : 0) != 0);
            Assert.assertTrue((millis - row.getDateTime(2).getMillis() > -86400000L ? 1 : 0) != 0);
            Assert.assertTrue(((long)timeMillis - row.getDateTime(3).getMillis() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue(((long)timeMillis - row.getDateTime(3).getMillis() > -1000L ? 1 : 0) != 0);
            Assert.assertTrue((millis - row.getDateTime(4).getMillis() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((millis - row.getDateTime(4).getMillis() > -1000L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)iter.hasNext());
            return null;
        }
    }
}

