/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.CheckSize;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamMinusRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamMinusRelTest.registerTable("ORDER_DETAILS1", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 4L, 4, new BigDecimal(4.0), 4L, 4, new BigDecimal(4.0)}));
        BeamMinusRelTest.registerTable("ORDER_DETAILS2", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 3L, 3, new BigDecimal(3.0)}));
    }

    @Test
    public void testExcept() throws Exception {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamMinusRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(4L, 4, new BigDecimal(4.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testExceptAll() throws Exception {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT ALL SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamMinusRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(3));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(1L, 1, new BigDecimal(1.0), 4L, 4, new BigDecimal(4.0), 4L, 4, new BigDecimal(4.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testExceptRemovesDuplicates() throws Exception {
        String sql = "(SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 1) EXCEPT SELECT 1";
        PCollection<Row> rows = BeamMinusRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(1));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "i").addRows(2).getRows());
        this.pipeline.run();
    }
}

