/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSqlOutputToConsoleFn;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestUnboundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamJoinRelUnboundedVsUnboundedTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    public static final DateTime FIRST_DATE = new DateTime(1L);
    public static final DateTime SECOND_DATE = new DateTime(3600001L);
    private static final Duration WINDOW_SIZE = Duration.standardHours((long)1L);

    @BeforeClass
    public static void prepare() {
        BeamJoinRelUnboundedVsUnboundedTest.registerTable("ORDER_DETAILS", (BeamSqlTable)TestUnboundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price", Schema.FieldType.DATETIME, "order_time"}).timestampColumnIndex(3).addRows(Duration.ZERO, new Object[]{1, 1, 1, FIRST_DATE, 1, 2, 6, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 2, 7, SECOND_DATE, 2, 3, 8, SECOND_DATE, 1, 3, 3, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)WINDOW_SIZE).plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 3, 3, SECOND_DATE}));
    }

    @Test
    public void testInnerJoin() throws Exception {
        String sql = "SELECT * FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o2  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsUnboundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.builder().addField("order_id1", Schema.FieldType.INT32).addField("sum_site_id", Schema.FieldType.INT32).addField("order_id", Schema.FieldType.INT32).addField("sum_site_id0", Schema.FieldType.INT32).build()).addRows(1, 3, 1, 3, 2, 5, 2, 5).getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testLeftOuterJoin() throws Exception {
        String sql = "SELECT * FROM (select site_id as order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY site_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  LEFT OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o2  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsUnboundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.builder().addField("order_id1", Schema.FieldType.INT32).addField("sum_site_id", Schema.FieldType.INT32).addNullableField("order_id", Schema.FieldType.INT32).addNullableField("sum_site_id0", Schema.FieldType.INT32).build()).addRows(1, 1, 1, 3, 2, 2, null, null, 2, 2, 2, 5, 3, 3, null, null).getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testRightOuterJoin() throws Exception {
        String sql = "SELECT * FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  RIGHT OUTER JOIN (select site_id as order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY site_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o2  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsUnboundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.builder().addNullableField("order_id1", Schema.FieldType.INT32).addNullableField("sum_site_id", Schema.FieldType.INT32).addField("order_id", Schema.FieldType.INT32).addField("sum_site_id0", Schema.FieldType.INT32).build()).addRows(1, 3, 1, 1, null, null, 2, 2, 2, 5, 2, 2, null, null, 3, 3).getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testFullOuterJoin() throws Exception {
        String sql = "SELECT * FROM (select price as order_id1, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY price, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  FULL OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id , TUMBLE(order_time, INTERVAL '1' HOUR)) o2  on  o1.order_id1=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsUnboundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        rows.apply((PTransform)ParDo.of((DoFn)new BeamSqlOutputToConsoleFn("hello")));
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.builder().addNullableField("order_id1", Schema.FieldType.INT32).addNullableField("sum_site_id", Schema.FieldType.INT32).addNullableField("order_id", Schema.FieldType.INT32).addNullableField("sum_site_id0", Schema.FieldType.INT32).build()).addRows(1, 1, 1, 3, 6, 2, null, null, 7, 2, null, null, 8, 3, null, null, null, null, 2, 5).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWindowsMismatch() throws Exception {
        String sql = "SELECT * FROM (select site_id as order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY site_id, TUMBLE(order_time, INTERVAL '2' HOUR)) o1  LEFT OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o2  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        BeamJoinRelUnboundedVsUnboundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        this.pipeline.run();
    }
}

