/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Test;

public class BeamDDLTest {
    @Test
    public void testParseCreateExternalTable_full() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        JSONObject properties = new JSONObject();
        JSONArray hello = new JSONArray();
        hello.add((Object)"james");
        hello.add((Object)"bond");
        properties.put("hello", (Object)hello);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", "person table", properties), tableProvider.getTables().get("person"));
    }

    @Test(expected=ParseException.class)
    public void testParseCreateExternalTable_withoutType() throws Exception {
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)new TestTableProvider());
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
    }

    @Test(expected=ParseException.class)
    public void testParseCreateTable() throws Exception {
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)new TestTableProvider());
        env.executeDdl("CREATE TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
    }

    @Test
    public void testParseCreateExternalTable_withoutTableComment() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        JSONObject properties = new JSONObject();
        JSONArray hello = new JSONArray();
        hello.add((Object)"james");
        hello.add((Object)"bond");
        properties.put("hello", (Object)hello);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", null, properties), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_withoutTblProperties() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\n");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", "person table", new JSONObject()), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_withoutLocation() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \n");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", "person table", new JSONObject(), null), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_minimal() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE person (id INT) TYPE text");
        Assert.assertEquals((Object)Table.builder().name("person").type("text").schema((Schema)Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withNullable(true)).collect(Schema.toSchema())).properties(new JSONObject()).build(), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_withDatabase() throws Exception {
        TestTableProvider rootProvider = new TestTableProvider();
        TestTableProvider testProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.builder((TableProvider)rootProvider).addSchema("test", (TableProvider)testProvider).build();
        Assert.assertNull(testProvider.getTables().get("person"));
        env.executeDdl("CREATE EXTERNAL TABLE test.person (id INT) TYPE text");
        Assert.assertNotNull(testProvider.getTables().get("person"));
    }

    @Test
    public void testParseDropTable() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        Assert.assertNull(tableProvider.getTables().get("person"));
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \n");
        Assert.assertNotNull(tableProvider.getTables().get("person"));
        env.executeDdl("drop table person");
        Assert.assertNull(tableProvider.getTables().get("person"));
    }

    private static Table mockTable(String name, String type, String comment, JSONObject properties) {
        return BeamDDLTest.mockTable(name, type, comment, properties, "/home/admin/" + name);
    }

    private static Table mockTable(String name, String type, String comment, JSONObject properties, String location) {
        return Table.builder().name(name).type(type).comment(comment).location(location).schema((Schema)Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withNullable(true).withDescription("id"), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withNullable(true).withDescription("name")).collect(Schema.toSchema())).properties(properties).build();
    }
}

